/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.common.checks;

import java.util.concurrent.TimeUnit;
import org.rnorth.ducttape.TimeoutException;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.wait.strategy.AbstractWaitStrategy;

public abstract class AbstractRetryingWaitStrategy
extends AbstractWaitStrategy {
    private static final Logger log = LoggerFactory.getLogger(AbstractRetryingWaitStrategy.class);

    protected String getContainerType() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected void waitUntilReady() {
        long seconds = this.startupTimeout.getSeconds();
        try {
            Unreliables.retryUntilTrue((int)((int)seconds), (TimeUnit)TimeUnit.SECONDS, () -> (Boolean)this.getRateLimiter().getWhenReady(this::isReady));
        }
        catch (TimeoutException e) {
            throw new ContainerLaunchException(String.format("[%s] notifies that container[%s] is not ready after [%d] seconds, container cannot be started.", this.getContainerType(), this.waitStrategyTarget.getContainerId(), seconds));
        }
    }

    protected abstract boolean isReady();
}

