/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.common.spring;

import com.playtika.test.common.spring.DependsOnDockerPostProcessor;
import com.playtika.test.common.spring.DockerPresenceMarker;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;

@Configuration
@AutoConfigureOrder(value=-2147483648)
@ConditionalOnProperty(prefix="embedded.containers", name={"enabled"}, matchIfMissing=true)
public class DockerPresenceBootstrapConfiguration {
    public static final String DOCKER_IS_AVAILABLE = "dockerPresenceMarker";

    @Bean(name={"dockerPresenceMarker"})
    public DockerPresenceMarker dockerPresenceMarker() {
        return new DockerPresenceMarker(DockerClientFactory.instance().isDockerAvailable());
    }

    @Bean
    public static DependsOnDockerPostProcessor containerDependsOnDockerPostProcessor() {
        return new DependsOnDockerPostProcessor(GenericContainer.class);
    }

    @Bean
    public static DependsOnDockerPostProcessor networkDependsOnDockerPostProcessor() {
        return new DependsOnDockerPostProcessor(Network.class);
    }
}

