/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.auth.common;

import com.alibaba.nacos.common.JustForTest;
import com.alibaba.nacos.common.event.ServerConfigChangeEvent;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.utils.ConvertUtils;
import com.alibaba.nacos.sys.env.EnvUtil;
import io.jsonwebtoken.io.Decoders;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AuthConfigs
extends Subscriber<ServerConfigChangeEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthConfigs.class);
    @JustForTest
    private static Boolean cachingEnabled = null;
    @Value(value="${nacos.core.auth.enabled:false}")
    private boolean authEnabled;
    @Value(value="${nacos.core.auth.default.token.secret.key:}")
    private String secretKey;
    private byte[] secretKeyBytes;
    @Value(value="${nacos.core.auth.default.token.expire.seconds:18000}")
    private long tokenValidityInSeconds;
    @Value(value="${nacos.core.auth.system.type:}")
    private String nacosAuthSystemType;
    @Value(value="${nacos.core.auth.server.identity.key:}")
    private String serverIdentityKey;
    @Value(value="${nacos.core.auth.server.identity.value:}")
    private String serverIdentityValue;
    @Value(value="${nacos.core.auth.enable.userAgentAuthWhite:false}")
    private boolean enableUserAgentAuthWhite;

    public AuthConfigs() {
        NotifyCenter.registerSubscriber((Subscriber)this);
    }

    public byte[] getSecretKeyBytes() {
        if (this.secretKeyBytes == null) {
            this.secretKeyBytes = (byte[])Decoders.BASE64.decode((Object)this.secretKey);
        }
        return this.secretKeyBytes;
    }

    public long getTokenValidityInSeconds() {
        return this.tokenValidityInSeconds;
    }

    public String getNacosAuthSystemType() {
        return this.nacosAuthSystemType;
    }

    public String getServerIdentityKey() {
        return this.serverIdentityKey;
    }

    public String getServerIdentityValue() {
        return this.serverIdentityValue;
    }

    public boolean isEnableUserAgentAuthWhite() {
        return this.enableUserAgentAuthWhite;
    }

    public boolean isAuthEnabled() {
        return this.authEnabled;
    }

    public boolean isCachingEnabled() {
        if (Objects.nonNull(cachingEnabled)) {
            return cachingEnabled;
        }
        return ConvertUtils.toBoolean((String)EnvUtil.getProperty((String)"nacos.core.auth.caching.enabled", (String)"true"));
    }

    @JustForTest
    public static void setCachingEnabled(boolean cachingEnabled) {
        AuthConfigs.cachingEnabled = cachingEnabled;
    }

    public void onEvent(ServerConfigChangeEvent event) {
        try {
            this.authEnabled = (Boolean)EnvUtil.getProperty((String)"nacos.core.auth.enabled", Boolean.class, (Object)false);
            cachingEnabled = (Boolean)EnvUtil.getProperty((String)"nacos.core.auth.caching.enabled", Boolean.class, (Object)true);
            this.serverIdentityKey = EnvUtil.getProperty((String)"nacos.core.auth.server.identity.key", (String)"");
            this.serverIdentityValue = EnvUtil.getProperty((String)"nacos.core.auth.server.identity.value", (String)"");
            this.enableUserAgentAuthWhite = (Boolean)EnvUtil.getProperty((String)"nacos.core.auth.enable.userAgentAuthWhite", Boolean.class, (Object)false);
        }
        catch (Exception e) {
            LOGGER.warn("Upgrade auth config from env failed, use old value", (Throwable)e);
        }
    }

    public Class<? extends Event> subscribeType() {
        return ServerConfigChangeEvent.class;
    }
}

