/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.util;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class ConcurrentLightHashSet<T> {
    private static final AtomicReferenceFieldUpdater<ConcurrentLightHashSet, Object> ELEMENTS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ConcurrentLightHashSet.class, Object.class, "elements");
    private volatile Object elements;

    public int size() {
        Object u = this.elements;
        if (u == null) {
            return 0;
        }
        if (u instanceof ConcurrentHashMap) {
            ConcurrentHashMap elementsMap = (ConcurrentHashMap)u;
            return elementsMap.size();
        }
        return 1;
    }

    public boolean addElement(T newElement) {
        Object oldElements;
        block5: {
            assert (newElement != null);
            while (true) {
                if ((oldElements = this.elements) == null) {
                    if (!ELEMENTS_UPDATER.compareAndSet(this, oldElements, newElement)) continue;
                    return true;
                }
                if (oldElements instanceof ConcurrentHashMap) {
                    ConcurrentHashMap elementsMap = (ConcurrentHashMap)oldElements;
                    return elementsMap.putIfAbsent(newElement, Boolean.TRUE) == null;
                }
                if (oldElements == newElement) break block5;
                ConcurrentHashMap<Object, Boolean> newElements = new ConcurrentHashMap<Object, Boolean>();
                newElements.put(oldElements, Boolean.TRUE);
                newElements.put(newElement, Boolean.TRUE);
                if (ELEMENTS_UPDATER.compareAndSet(this, oldElements, newElements)) break;
            }
            return true;
        }
        assert (oldElements == newElement);
        return false;
    }

    public Set<T> getElements() {
        Object u = this.elements;
        if (u == null) {
            return Collections.emptySet();
        }
        if (u instanceof ConcurrentHashMap) {
            ConcurrentHashMap elementsMap = (ConcurrentHashMap)u;
            return elementsMap.keySet();
        }
        return Collections.singleton(u);
    }

    public boolean removeElement(T element) {
        block2: {
            Object e;
            do {
                if ((e = this.elements) instanceof ConcurrentHashMap) {
                    ConcurrentHashMap elementsMap = (ConcurrentHashMap)e;
                    return elementsMap.remove(element) != null;
                }
                if (!element.equals(e)) break block2;
            } while (!ELEMENTS_UPDATER.compareAndSet(this, e, null));
            return true;
        }
        return false;
    }

    public void clear() {
        while (!ELEMENTS_UPDATER.compareAndSet(this, this.elements, null)) {
        }
    }
}

