/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.context.bytecode;

import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import java.util.Arrays;

public final class BytecodeAnalysisContext
extends AnalysisContext {
    public static final BytecodeLocation[] emptyLabelList = new BytecodeLocation[0];
    protected final BytecodeLocation[] labels;

    protected BytecodeAnalysisContext(BytecodeLocation[] labelList) {
        this.labels = labelList;
    }

    public int getLength() {
        return this.labels.length;
    }

    public BytecodeLocation[] labels() {
        return this.labels;
    }

    @Override
    protected boolean valueEquals(AnalysisContext obj) {
        if (obj instanceof BytecodeAnalysisContext) {
            BytecodeAnalysisContext that = (BytecodeAnalysisContext)obj;
            return Arrays.equals(this.labels, that.labels);
        }
        return false;
    }

    @Override
    protected int valueHashCode() {
        int result = 42;
        for (BytecodeLocation l : this.labels) {
            result ^= l.hashCode();
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        String separator = " ";
        for (BytecodeLocation bytecode : this.labels) {
            result.append(separator).append(bytecode);
            separator = "\t";
        }
        return result.toString();
    }
}

