/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.retrier;

import com.oracle.bmc.retrier.DefaultRetryCondition;
import com.oracle.bmc.retrier.RetryCondition;
import com.oracle.bmc.retrier.RetryOptions;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.ExponentialBackoffDelayStrategy;
import com.oracle.bmc.waiter.ExponentialBackoffDelayStrategyWithJitter;
import com.oracle.bmc.waiter.MaxAttemptsTerminationStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.WaiterConfiguration;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class RetryConfiguration
extends WaiterConfiguration {
    public static final RetryConfiguration NO_RETRY_CONFIGURATION = RetryConfiguration.builder().build();
    public static final int DEFAULT_MAX_RETRY_ATTEMPTS = 8;
    public static final long DEFAULT_MAX_WAIT_TIME = TimeUnit.SECONDS.toMillis(30L);
    public static final RetryConfiguration SDK_DEFAULT_RETRY_CONFIGURATION = RetryConfiguration.builder().terminationStrategy(new MaxAttemptsTerminationStrategy(8)).delayStrategy(new ExponentialBackoffDelayStrategyWithJitter(DEFAULT_MAX_WAIT_TIME)).retryCondition(exception -> new DefaultRetryCondition().shouldBeRetried(exception)).build();
    private final RetryCondition retryCondition;
    private final RetryOptions retryOptions;

    private RetryConfiguration(@Nonnull TerminationStrategy terminationStrategy, @Nonnull DelayStrategy delayStrategy, @Nonnull RetryCondition retryCondition, @Nonnull RetryOptions retryOptions) {
        super(terminationStrategy, delayStrategy);
        if (terminationStrategy == null) {
            throw new NullPointerException("terminationStrategy is marked non-null but is null");
        }
        if (delayStrategy == null) {
            throw new NullPointerException("delayStrategy is marked non-null but is null");
        }
        if (retryCondition == null) {
            throw new NullPointerException("retryCondition is marked non-null but is null");
        }
        if (retryOptions == null) {
            throw new NullPointerException("retryOptions is marked non-null but is null");
        }
        this.retryCondition = retryCondition;
        this.retryOptions = retryOptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String toString() {
        return "RetryConfiguration(super=" + super.toString() + ", retryCondition=" + this.getRetryCondition() + ", retryOptions=" + this.getRetryOptions() + ")";
    }

    public RetryCondition getRetryCondition() {
        return this.retryCondition;
    }

    public RetryOptions getRetryOptions() {
        return this.retryOptions;
    }

    public static class Builder {
        private static final TerminationStrategy NO_RETRY_TERMINATION_STRATEGY = new MaxAttemptsTerminationStrategy(1);
        private static final DelayStrategy EXPONENTIAL_BACKOFF_DELAY_STRATEGY = new ExponentialBackoffDelayStrategy(TimeUnit.SECONDS.toMillis(30L));
        private static final RetryOptions DEFAULT_RETRY_OPTIONS = new RetryOptions(Integer.MAX_VALUE);
        private TerminationStrategy terminationStrategy = NO_RETRY_TERMINATION_STRATEGY;
        private DelayStrategy delayStrategy = EXPONENTIAL_BACKOFF_DELAY_STRATEGY;
        private RetryCondition retryCondition = new DefaultRetryCondition();
        private RetryOptions retryOptions = DEFAULT_RETRY_OPTIONS;

        public Builder terminationStrategy(@Nonnull TerminationStrategy terminationStrategy) {
            if (terminationStrategy == null) {
                throw new NullPointerException("terminationStrategy is marked non-null but is null");
            }
            this.terminationStrategy = terminationStrategy;
            return this;
        }

        public Builder delayStrategy(@Nonnull DelayStrategy delayStrategy) {
            if (delayStrategy == null) {
                throw new NullPointerException("delayStrategy is marked non-null but is null");
            }
            this.delayStrategy = delayStrategy;
            return this;
        }

        public Builder retryCondition(@Nonnull RetryCondition retryCondition) {
            if (retryCondition == null) {
                throw new NullPointerException("retryCondition is marked non-null but is null");
            }
            this.retryCondition = retryCondition;
            return this;
        }

        public Builder retryOptions(@Nonnull RetryOptions retryOptions) {
            if (retryOptions == null) {
                throw new NullPointerException("retryOptions is marked non-null but is null");
            }
            this.retryOptions = retryOptions;
            return this;
        }

        public RetryConfiguration build() {
            return new RetryConfiguration(this.terminationStrategy, this.delayStrategy, this.retryCondition, this.retryOptions);
        }
    }
}

