/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.oracle.bmc.http.Serialization;
import com.oracle.bmc.util.internal.ReflectionUtils;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Variant;

public class EntityFactory {
    Entity<?> forPatch(Object request, Object body) {
        if (body == null) {
            return null;
        }
        return Entity.json((Object)EntityFactory.getBodyAsString(body));
    }

    Entity<?> forPost(Object request, Object body) {
        if (body == null) {
            return null;
        }
        Entity requestBody = null;
        requestBody = body instanceof InputStream ? Entity.entity((Object)body, (Variant)InputStreamVariantCreator.create(request)) : Entity.json((Object)EntityFactory.getBodyAsString(body));
        return requestBody;
    }

    Entity<?> forPut(Object request, Object body) {
        if (body == null) {
            return null;
        }
        Entity requestBody = null;
        requestBody = body instanceof InputStream ? Entity.entity((Object)body, (Variant)InputStreamVariantCreator.create(request)) : Entity.json((Object)EntityFactory.getBodyAsString(body));
        return requestBody;
    }

    static String getBodyAsString(@Nullable Object body) {
        try {
            return body instanceof String ? (String)body : Serialization.getObjectMapper().writeValueAsString(body);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable to process JSON body", e);
        }
    }

    private static final class InputStreamVariantCreator {
        private InputStreamVariantCreator() {
        }

        private static Variant create(Object request) {
            String contentType = InputStreamVariantCreator.getValue(request, "getContentType", "application/octet-stream");
            String contentLanguage = InputStreamVariantCreator.getValue(request, "getContentLanguage", null);
            String contentEncoding = InputStreamVariantCreator.getValue(request, "getContentEncoding", null);
            return new Variant(MediaType.valueOf((String)contentType), contentLanguage, contentEncoding);
        }

        private static String getValue(Object request, String methodName, String defaultValue) {
            Object response = ReflectionUtils.invokeGetter(request, methodName);
            if (response != null && response instanceof String) {
                return (String)response;
            }
            return defaultValue;
        }
    }
}

