/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http;

import com.oracle.bmc.util.internal.StringUtils;
import java.beans.ConstructorProperties;

public class ApacheProxyConfig {
    private final String uri;
    private final String username;
    private final String password;

    @ConstructorProperties(value={"uri", "username", "password"})
    ApacheProxyConfig(String uri, String username, String password) {
        this.uri = uri;
        this.username = username;
        this.password = password;
    }

    public static ApacheProxyConfigBuilder builder() {
        return new ApacheProxyConfigBuilder();
    }

    public boolean isConfiguredAndValid() {
        boolean isCredentialsValid = this.username != null && this.password != null || this.username == null && this.password == null;
        return StringUtils.isNotBlank(this.uri) && isCredentialsValid;
    }

    public String toString() {
        String providedValue = "<Provided>";
        String username = this.username != null ? "<Provided>" : null;
        String password = this.password != null ? "<Provided>" : null;
        return String.format("[uri: %s, username: %s, password: %s]", this.uri, username, password);
    }

    public String getUri() {
        return this.uri;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApacheProxyConfig)) {
            return false;
        }
        ApacheProxyConfig other = (ApacheProxyConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApacheProxyConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public static class ApacheProxyConfigBuilder {
        private String uri;
        private String username;
        private String password;

        ApacheProxyConfigBuilder() {
        }

        public ApacheProxyConfigBuilder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public ApacheProxyConfigBuilder username(String username) {
            this.username = username;
            return this;
        }

        public ApacheProxyConfigBuilder password(String password) {
            this.password = password;
            return this;
        }

        public ApacheProxyConfig build() {
            return new ApacheProxyConfig(this.uri, this.username, this.password);
        }

        public String toString() {
            return "ApacheProxyConfig.ApacheProxyConfigBuilder(uri=" + this.uri + ", username=" + this.username + ", password=" + this.password + ")";
        }
    }
}

