/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.common;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.Service;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.util.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class ClientBuilderBase<B extends ClientBuilderBase, C> {
    protected final Service service;
    protected ClientConfiguration configuration;
    protected ClientConfigurator clientConfigurator;
    protected List<ClientConfigurator> additionalClientConfigurators = new ArrayList<ClientConfigurator>();
    protected RequestSignerFactory requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
    protected Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories = DefaultRequestSignerFactory.createDefaultRequestSignerFactories();
    protected String endpoint;
    protected RestClientFactoryBuilder restClientFactoryBuilder = RestClientFactoryBuilder.builder();

    public ClientBuilderBase(Service service) {
        this.service = service;
    }

    public B configuration(ClientConfiguration configuration) {
        this.configuration = configuration;
        return (B)this;
    }

    public B clientConfigurator(ClientConfigurator clientConfigurator) {
        this.clientConfigurator = clientConfigurator;
        return (B)this;
    }

    public B additionalClientConfigurator(@Nonnull ClientConfigurator additionalClientConfigurator) {
        if (additionalClientConfigurator == null) {
            throw new NullPointerException("additionalClientConfigurator is marked non-null but is null");
        }
        this.additionalClientConfigurators.add(additionalClientConfigurator);
        return (B)this;
    }

    public B requestSignerFactory(RequestSignerFactory requestSignerFactory) {
        this.requestSignerFactory = requestSignerFactory == null ? new DefaultRequestSignerFactory(SigningStrategy.STANDARD) : requestSignerFactory;
        return (B)this;
    }

    public B endpoint(String endpoint) {
        this.endpoint = endpoint;
        return (B)this;
    }

    public B signingStrategyRequestSignerFactories(Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories) {
        HashMap<SigningStrategy, RequestSignerFactory> copy = new HashMap<SigningStrategy, RequestSignerFactory>(signingStrategyRequestSignerFactories);
        this.signingStrategyRequestSignerFactories = Collections.unmodifiableMap(copy);
        return (B)this;
    }

    @InternalSdk
    @VisibleForTesting
    public B restClientFactoryBuilder(RestClientFactoryBuilder restClientFactoryBuilder) {
        this.restClientFactoryBuilder = restClientFactoryBuilder;
        return (B)this;
    }

    public abstract C build(@Nonnull AbstractAuthenticationDetailsProvider var1);
}

