/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.cli.urlbuilder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import oracle.net.url.builder.ConnectDescriptorBuilder;

public class ConnectionOptionsHandler {
    public static final String CATEGORY_AVAILABILITY = "AVAILABILITY";
    public static final String CATEGORY_PERFORMANCE = "PERFORMANCE";
    public static final String CATEGORY_TIMEOUT = "TIMEOUT";
    public static final String CATEGORY_BUFFER = "BUFFER";
    public static final String CATEGORY_COMPRESSION = "COMPRESSION";
    public static final String CATEGORY_ADVANCED = "ADVANCED";
    private final Map<String, List<ConnectionOption>> optionCategories = new HashMap<String, List<ConnectionOption>>();

    public ConnectionOptionsHandler() {
        this.initializeAvailabilityOptions();
        this.initializeTimeoutOptions();
        this.initializePerformanceOptions();
        this.initializeBufferOptions();
        this.initializeCompressionOptions();
        this.initializeAdvancedOptions();
    }

    private void initializeAvailabilityOptions() {
        ArrayList<ConnectionOption> options = new ArrayList<ConnectionOption>();
        options.add(new ConnectionOption("FAILOVER", "Failover", "Enables or disables connect-time failover for multiple connection addresses", "true", s -> s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false"), (consumer, value) -> consumer.failOver(Boolean.parseBoolean(value))));
        options.add(new ConnectionOption("LOAD_BALANCE", "Load Balance", "Enables or disables client load balancing for multiple connection addresses", "true", s -> s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false"), (consumer, value) -> consumer.loadBalance(Boolean.parseBoolean(value))));
        options.add(new ConnectionOption("SOURCE_ROUTE", "Source Route", "Enables or disables routing of connections through multiple listeners", "false", s -> s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false"), (consumer, value) -> consumer.sourceRoute(Boolean.parseBoolean(value))));
        this.optionCategories.put(CATEGORY_AVAILABILITY, options);
    }

    private void initializeTimeoutOptions() {
        ArrayList<ConnectionOption> options = new ArrayList<ConnectionOption>();
        options.add(new ConnectionOption("CONNECT_TIMEOUT", "Connect Timeout", "Time limit for establishing a connection (in seconds)", "60", ConnectionOptionsHandler::validatePositiveInteger, (consumer, value) -> consumer.connectTimeout(Integer.parseInt(value))));
        options.add(new ConnectionOption("TRANSPORT_CONNECT_TIMEOUT", "Transport Connect Timeout", "Time limit for establishing a network transport (in seconds)", "60", ConnectionOptionsHandler::validatePositiveInteger, (consumer, value) -> consumer.transportTimeout(Integer.parseInt(value))));
        options.add(new ConnectionOption("RETRY_COUNT", "Retry Count", "Number of times to attempt establishing a connection", "0", ConnectionOptionsHandler::validateNonNegativeInteger, (consumer, value) -> consumer.retryCount(Integer.parseInt(value))));
        options.add(new ConnectionOption("RETRY_DELAY", "Retry Delay", "Time delay (in seconds) between connection retries", "0", ConnectionOptionsHandler::validateNonNegativeInteger, (consumer, value) -> consumer.retryDelay(Integer.parseInt(value))));
        options.add(new ConnectionOption("EXPIRE_TIME", "Expire Time", "Time (in minutes) after which idle connections are terminated", "0", ConnectionOptionsHandler::validateNonNegativeInteger, (consumer, value) -> consumer.expireTime(Integer.parseInt(value))));
        this.optionCategories.put(CATEGORY_TIMEOUT, options);
    }

    private void initializePerformanceOptions() {
        ArrayList<ConnectionOption> options = new ArrayList<ConnectionOption>();
        options.add(new ConnectionOption("ENABLE", "Keep Alive (Broken Connection Detection)", "Enable detection of broken connections (ON, BROKEN, OFF)", "BROKEN", s -> s.equalsIgnoreCase("ON") || s.equalsIgnoreCase("BROKEN") || s.equalsIgnoreCase("OFF"), (consumer, value) -> consumer.keepAlive(value.equalsIgnoreCase("BROKEN") || value.equalsIgnoreCase("ON"))));
        options.add(new ConnectionOption("USE_SNI", "Use Server Name Indication (SNI)", "Enable Server Name Indication for TLS connections", "false", s -> s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false"), (consumer, value) -> consumer.useSNI(Boolean.parseBoolean(value))));
        this.optionCategories.put(CATEGORY_PERFORMANCE, options);
    }

    private void initializeBufferOptions() {
        ArrayList<ConnectionOption> options = new ArrayList<ConnectionOption>();
        options.add(new ConnectionOption("SDU", "Session Data Unit Size", "Size of session data unit in bytes (512 to 65535)", "8192", s -> {
            try {
                int value = Integer.parseInt(s);
                return value >= 512 && value <= 65535;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }, (consumer, value) -> consumer.sdu(Integer.parseInt(value))));
        options.add(new ConnectionOption("TDU", "Transport Data Unit Size", "Size of transport data unit in bytes (512 to 65535)", "32767", s -> {
            try {
                int value = Integer.parseInt(s);
                return value >= 512 && value <= 65535;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }, (consumer, value) -> consumer.tdu(Integer.parseInt(value))));
        options.add(new ConnectionOption("SEND_BUF_SIZE", "Send Buffer Size", "Size of socket send buffer in bytes", "65536", ConnectionOptionsHandler::validatePositiveInteger, (consumer, value) -> consumer.sendBufferSize(Integer.parseInt(value))));
        options.add(new ConnectionOption("RECV_BUF_SIZE", "Receive Buffer Size", "Size of socket receive buffer in bytes", "65536", ConnectionOptionsHandler::validatePositiveInteger, (consumer, value) -> consumer.receiveBufferSize(Integer.parseInt(value))));
        this.optionCategories.put(CATEGORY_BUFFER, options);
    }

    private void initializeCompressionOptions() {
        ArrayList<ConnectionOption> options = new ArrayList<ConnectionOption>();
        options.add(new ConnectionOption(CATEGORY_COMPRESSION, "Compression", "Enable network data compression", "false", s -> s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false"), (consumer, value) -> consumer.compression(Boolean.parseBoolean(value))));
        options.add(new ConnectionOption("COMPRESSION_LEVELS", "Compression Levels", "Comma-separated list of compression levels (e.g., LOW,MEDIUM,HIGH)", "MEDIUM", s -> s.matches("(?i)(LOW|MEDIUM|HIGH)(,(LOW|MEDIUM|HIGH))*"), (consumer, value) -> consumer.compressionLevels(value.split(","))));
        this.optionCategories.put(CATEGORY_COMPRESSION, options);
    }

    private void initializeAdvancedOptions() {
        ArrayList options = new ArrayList();
        this.optionCategories.put(CATEGORY_ADVANCED, options);
    }

    private static boolean validatePositiveInteger(String input) {
        try {
            int value = Integer.parseInt(input);
            return value > 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean validateNonNegativeInteger(String input) {
        try {
            int value = Integer.parseInt(input);
            return value >= 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public Map<String, String> promptConnectionOptions(Scanner scanner) {
        HashMap<String, String> selectedOptions = new HashMap<String, String>();
        System.out.println("\n=== Connection Options ===");
        while (true) {
            System.out.println("Select categories of options to configure:");
            System.out.println("1. Availability Options (Failover, Load Balancing)");
            System.out.println("2. Timeout Options");
            System.out.println("3. Performance Options");
            System.out.println("4. Buffer Size Options");
            System.out.println("5. Compression Options");
            System.out.println("6. Advanced Options");
            System.out.println("0. Done (no more options)");
            System.out.print("\nEnter category number (0-6): ");
            String input = scanner.nextLine().trim();
            if (input.equals("0")) break;
            try {
                int category = Integer.parseInt(input);
                switch (category) {
                    case 1: {
                        this.promptCategoryOptions(scanner, CATEGORY_AVAILABILITY, selectedOptions);
                        break;
                    }
                    case 2: {
                        this.promptCategoryOptions(scanner, CATEGORY_TIMEOUT, selectedOptions);
                        break;
                    }
                    case 3: {
                        this.promptCategoryOptions(scanner, CATEGORY_PERFORMANCE, selectedOptions);
                        break;
                    }
                    case 4: {
                        this.promptCategoryOptions(scanner, CATEGORY_BUFFER, selectedOptions);
                        break;
                    }
                    case 5: {
                        this.promptCategoryOptions(scanner, CATEGORY_COMPRESSION, selectedOptions);
                        break;
                    }
                    case 6: {
                        this.promptCategoryOptions(scanner, CATEGORY_ADVANCED, selectedOptions);
                        break;
                    }
                    default: {
                        System.out.println("Invalid option. Please enter a number between 0 and 6.");
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid input. Please enter a number.");
            }
        }
        return selectedOptions;
    }

    private void promptCategoryOptions(Scanner scanner, String categoryType, Map<String, String> selectedOptions) {
        List<ConnectionOption> options = this.optionCategories.get(categoryType);
        if (options.isEmpty()) {
            System.out.println("\nNo options available in this category.");
            return;
        }
        while (true) {
            System.out.println("\n=== " + categoryType + " Options ===");
            for (int i = 0; i < options.size(); ++i) {
                ConnectionOption option = options.get(i);
                System.out.println(i + 1 + ". " + option.displayName);
            }
            System.out.println("0. Back to main menu");
            System.out.print("\nEnter option number (0-" + options.size() + "): ");
            String input = scanner.nextLine().trim();
            if (input.equals("0")) break;
            try {
                int optionIndex = Integer.parseInt(input) - 1;
                if (optionIndex >= 0 && optionIndex < options.size()) {
                    ConnectionOption option = options.get(optionIndex);
                    this.promptOptionValue(scanner, option, selectedOptions);
                    continue;
                }
                System.out.println("Invalid option. Please enter a number between 0 and " + options.size() + ".");
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid input. Please enter a number.");
            }
        }
    }

    private void promptOptionValue(Scanner scanner, ConnectionOption option, Map<String, String> selectedOptions) {
        System.out.println("\n" + option.displayName);
        System.out.println("Description: " + option.description);
        if (!option.defaultValue.isEmpty()) {
            System.out.println("Default value: " + option.defaultValue);
        }
        while (true) {
            System.out.print("Enter value (or press Enter for default, 'skip' to skip): ");
            String input = scanner.nextLine().trim();
            if (input.equalsIgnoreCase("skip")) {
                System.out.println("Skipping " + option.name);
                return;
            }
            if (input.isEmpty() && !option.defaultValue.isEmpty()) {
                input = option.defaultValue;
                System.out.println("Using default value: " + input);
            }
            if (option.validator.test(input)) {
                selectedOptions.put(option.name, input);
                System.out.println(option.name + " set to: " + input);
                return;
            }
            System.out.println("Invalid value. Please try again.");
        }
    }

    public void applyConnectionOptions(ConnectDescriptorBuilder.DescriptionNode description, Map<String, String> options) {
        if (options == null || options.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : options.entrySet()) {
            String optionName = entry.getKey();
            String optionValue = entry.getValue();
            ConnectionOption option = this.findOptionByName(optionName);
            if (option != null && option.applier != null) {
                option.applier.accept(description, optionValue);
                continue;
            }
            description.param(optionName, optionValue);
        }
    }

    private ConnectionOption findOptionByName(String name) {
        for (List<ConnectionOption> options : this.optionCategories.values()) {
            for (ConnectionOption option : options) {
                if (!option.name.equals(name)) continue;
                return option;
            }
        }
        return null;
    }

    public static String formatOptionsForReview(Map<String, String> options) {
        if (options == null || options.isEmpty()) {
            return "None";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : options.entrySet()) {
            sb.append("\n    ").append(entry.getKey()).append(" = ").append(entry.getValue());
        }
        return sb.toString();
    }

    private static class ConnectionOption {
        final String name;
        final String displayName;
        final String description;
        final String defaultValue;
        final Predicate<String> validator;
        final BiConsumer<ConnectDescriptorBuilder.DescriptionNode, String> applier;

        ConnectionOption(String name, String displayName, String description, String defaultValue, Predicate<String> validator, BiConsumer<ConnectDescriptorBuilder.DescriptionNode, String> applier) {
            this.name = name;
            this.displayName = displayName;
            this.description = description;
            this.defaultValue = defaultValue;
            this.validator = validator;
            this.applier = applier;
        }
    }
}

