/*
 * Decompiled with CFR 0.152.
 */
package oracle.simplefan.impl;

import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.ons.ONS;
import oracle.ons.ONSException;
import oracle.simplefan.impl.FanSubscription;

public final class FanManager
extends oracle.simplefan.FanManager {
    static final Logger logger = Logger.getLogger("oracle.simplefan.FanManager");
    private static final FanManager soleInstance = new FanManager();
    private boolean isConfigured = false;
    private ONS ons = null;

    public static final FanManager getInstanceInternal() {
        return soleInstance;
    }

    public final synchronized void configure(Properties properties) {
        if (this.isConfigured) {
            logger.warning("attempt to configure FanManager more than once");
            throw new IllegalStateException("attempt to configure oracle.simplefan.FanManager more than once");
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        Object object = properties.propertyNames();
        while (object.hasMoreElements()) {
            String string4 = (String)object.nextElement();
            if (string4.equals("onsNodes")) {
                string = properties.getProperty(string4);
                continue;
            }
            if (string4.equals("onsWalletFile")) {
                string2 = properties.getProperty(string4);
                continue;
            }
            if (string4.equals("onsWalletPassword")) {
                string3 = properties.getProperty(string4);
                continue;
            }
            logger.severe("unrecognized property while configuring FanManager");
            throw new IllegalArgumentException("unrecognized property \"" + string4 + "\"");
        }
        try {
            object = "nodes=" + string + "\n" + (string2 == "" ? "" : "walletfile=" + string2 + "\n") + (string3 == "" ? "" : "walletpassword=" + string3 + "\n");
            logger.config("creating ONS: nodes=\"" + string + "\" walletfile=\"" + string2 + "\" walletpassword=\"" + "********************************************************************".substring(0, string3.length()) + "\"");
            this.ons = AccessController.doPrivileged(new PrivilegedExceptionAction<ONS>((String)object){
                final /* synthetic */ String val$s;
                {
                    this.val$s = string;
                }

                @Override
                public ONS run() throws ONSException {
                    return new ONS(this.val$s);
                }
            });
        }
        catch (Exception exception) {
            logger.severe("attempt to configure ONS in FanManager failed with " + exception);
            throw new IllegalArgumentException("ONS configuration failed", exception);
        }
        logger.config("ONS created");
        this.isConfigured = true;
    }

    public final synchronized oracle.simplefan.FanSubscription subscribe(Properties properties) {
        FanSubscription fanSubscription;
        String string = properties.getProperty("serviceName");
        if (string == null || string.length() == 0) {
            logger.severe("attempt to create FanSubscription with null serviceName");
            throw new IllegalArgumentException("serviceName is null");
        }
        if (properties.size() != 1) {
            logger.severe("attempt to create FanSubscription with unknown property");
            throw new IllegalArgumentException("unrecognized property");
        }
        try {
            fanSubscription = this.ons == null ? FanSubscription.createFanSubscription(string) : FanSubscription.createFanSubscription(this.ons, string);
        }
        catch (ONSException oNSException) {
            logger.severe("attempt to create FanSubscription failed");
            throw new IllegalArgumentException("unable to create ONS subscriber with properties provided", oNSException);
        }
        logger.finest("attempt to create FanSubscription succeeded");
        this.isConfigured = true;
        return fanSubscription;
    }
}

