/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.LocalPlatform;
import com.oracle.bedrock.runtime.Platform;
import java.util.function.Predicate;

public interface PlatformPredicate
extends Predicate<Platform>,
Option {
    public static PlatformPredicate isLocal() {
        return platform -> platform instanceof LocalPlatform;
    }

    @OptionsByType.Default
    public static PlatformPredicate any() {
        return platform -> true;
    }

    public static PlatformPredicate none() {
        return platform -> false;
    }

    public static PlatformPredicate of(Predicate<? super Platform> predicate) {
        return platform -> predicate.test((Platform)platform);
    }

    public static PlatformPredicate named(String regularExpression) {
        return platform -> platform.getName().matches(regularExpression);
    }

    public static PlatformPredicate is(Platform platform) {
        return p -> p.equals(platform);
    }
}

