/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.java.options.SystemProperties;
import java.util.Iterator;
import java.util.function.Supplier;

public class SystemProperty
implements Option.Collectable {
    private final String name;
    private final Object value;
    private final Option[] options;

    private SystemProperty(String name, Object value, Option ... options) {
        this.name = name;
        this.value = value;
        this.options = options;
    }

    public static SystemProperty of(String name, Option ... options) {
        return new SystemProperty(name, "", options);
    }

    public static SystemProperty of(String name, String value, Option ... options) {
        return new SystemProperty(name, value, options);
    }

    public static SystemProperty of(String name, ContextSensitiveValue value, Option ... options) {
        return new SystemProperty(name, value, options);
    }

    public static SystemProperty of(String name, Supplier<?> value, Option ... options) {
        return new SystemProperty(name, value, options);
    }

    public static SystemProperty of(String name, Iterator iterator, Option ... options) {
        return new SystemProperty(name, iterator, options);
    }

    public static SystemProperty of(String name, Object object, Option ... options) {
        return new SystemProperty(name, object, options);
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public OptionsByType getOptions() {
        return OptionsByType.of((Option[])this.options);
    }

    public String toString() {
        return String.format("{name=%s, value=%s}", this.name, this.value);
    }

    public Class<SystemProperties> getCollectorClass() {
        return SystemProperties.class;
    }

    @FunctionalInterface
    public static interface ResolveHandler {
        public void onResolve(String var1, String var2, OptionsByType var3);
    }

    public static interface ContextSensitiveValue {
        public Object resolve(String var1, Platform var2, OptionsByType var3);
    }
}

