/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java.options;

import com.oracle.bedrock.ComposableOption;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.java.ClassPath;
import com.oracle.bedrock.runtime.java.options.JvmOption;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class JavaModules
implements ComposableOption<JavaModules>,
JvmOption {
    private final boolean enabled;
    private final Set<String> modules;
    private final Set<String> excludes;
    private final Set<String> exports;
    private final Set<String> patches;
    private final Set<String> reading;
    private final Set<String> opens;
    private final ClassPath classPath;
    public static final String PROP_USE_MODULES = "com.oracle.bedrock.modules.enabled";

    private JavaModules(boolean enabled, Set<String> modules, Set<String> excludes, Set<String> exports, Set<String> patches, Set<String> reading, Set<String> opens, ClassPath classPath) {
        this.enabled = enabled;
        this.modules = modules;
        this.excludes = excludes;
        this.exports = exports;
        this.patches = patches;
        this.reading = reading;
        this.opens = opens;
        this.classPath = classPath;
    }

    public static JavaModules enabled() {
        return new JavaModules(true, Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), ClassPath.ofSystem());
    }

    public static JavaModules disabled() {
        return new JavaModules(false, Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), ClassPath.ofSystem());
    }

    @OptionsByType.Default
    public static JavaModules automatic() {
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = bean.getInputArguments();
        return JavaModules.automatic(JavaModules.useModules(), arguments);
    }

    static JavaModules automatic(boolean useModules, List<String> arguments) {
        HashSet<String> patches = new HashSet<String>();
        HashSet<String> modules = new HashSet<String>();
        HashSet<String> reads = new HashSet<String>();
        HashSet<String> opens = new HashSet<String>();
        HashSet<String> exports = new HashSet<String>();
        int end = arguments.size() - 1;
        for (int i = 0; i <= end; ++i) {
            String arg = arguments.get(i);
            if (arg.startsWith("--patch-module=")) {
                patches.add(arg.substring(15));
                continue;
            }
            if (arg.equals("--patch-module") && i < end) {
                patches.add(arguments.get(++i));
                continue;
            }
            if (arg.startsWith("--add-modules=")) {
                modules.add(arg.substring(14));
                continue;
            }
            if (arg.equals("--add-modules") && i < end) {
                modules.add(arguments.get(++i));
                continue;
            }
            if (arg.startsWith("--add-reads=")) {
                reads.add(arg.substring(12));
                continue;
            }
            if (arg.equals("--add-reads") && i < end) {
                reads.add(arguments.get(++i));
                continue;
            }
            if (arg.startsWith("--add-opens=")) {
                opens.add(arg.substring(12));
                continue;
            }
            if (arg.equals("--add-opens") && i < end) {
                opens.add(arguments.get(++i));
                continue;
            }
            if (arg.startsWith("--add-exports=")) {
                exports.add(arg.substring(14));
                continue;
            }
            if (!arg.equals("--add-exports") || i >= end) continue;
            exports.add(arguments.get(++i));
        }
        return new JavaModules(useModules, modules, Collections.emptySet(), exports, patches, reads, opens, ClassPath.ofSystem());
    }

    public static boolean useModules() {
        String useModulesProperty = System.getProperty(PROP_USE_MODULES);
        if (useModulesProperty == null || useModulesProperty.isBlank()) {
            String modulePath = System.getProperty("jdk.module.path");
            return modulePath != null && !modulePath.isBlank();
        }
        return Boolean.parseBoolean(useModulesProperty);
    }

    public JavaModules adding(String ... modules) {
        if (modules.length == 0) {
            return this;
        }
        return new JavaModules(true, JavaModules.toSet(this.modules, modules), this.excludes, this.exports, this.patches, this.reading, this.opens, this.classPath);
    }

    public JavaModules excluding(String ... modules) {
        if (modules.length == 0) {
            return this;
        }
        return new JavaModules(true, this.modules, JavaModules.toSet(this.excludes, modules), this.exports, this.patches, this.reading, this.opens, this.classPath);
    }

    public JavaModules exporting(String ... exports) {
        return new JavaModules(true, this.modules, this.excludes, JavaModules.toSet(this.exports, exports), this.patches, this.reading, this.opens, this.classPath);
    }

    public JavaModules exportingTo(String toModule, String ... modules) {
        if (modules.length == 0) {
            return this;
        }
        LinkedHashSet<String> exports = new LinkedHashSet<String>(this.exports);
        Arrays.stream(modules).map(m -> m + "/" + m + "=" + toModule).forEach(exports::add);
        return new JavaModules(true, this.modules, this.excludes, exports, this.patches, this.reading, this.opens, this.classPath);
    }

    public JavaModules exportingToBedrock(String ... modules) {
        return this.exportingTo("com.oracle.bedrock.runtime", modules);
    }

    public JavaModules opens(String module, String _package, String targetModule) {
        if (module == null || _package == null || targetModule == null) {
            return this;
        }
        LinkedHashSet<String> opens = new LinkedHashSet<String>(this.opens);
        opens.add(module + "/" + _package + "=" + targetModule);
        return new JavaModules(true, this.modules, this.excludes, this.exports, this.patches, this.reading, opens, this.classPath);
    }

    public JavaModules patching(String ... patches) {
        if (patches.length == 0) {
            return this;
        }
        return new JavaModules(true, this.modules, this.excludes, this.exports, JavaModules.toSet(this.patches, patches), this.reading, this.opens, this.classPath);
    }

    public JavaModules reading(String ... reads) {
        if (reads.length == 0) {
            return this;
        }
        return new JavaModules(true, this.modules, this.excludes, this.exports, this.patches, JavaModules.toSet(this.reading, reads), this.opens, this.classPath);
    }

    public JavaModules withClassPath(ClassPath classPath) {
        if (classPath == null) {
            classPath = ClassPath.ofSystem();
        }
        return new JavaModules(true, this.modules, this.excludes, this.exports, this.patches, this.reading, this.opens, classPath);
    }

    public JavaModules appendingToClassPath(ClassPath classPath) {
        if (classPath == null || classPath.isEmpty()) {
            return this;
        }
        return new JavaModules(true, this.modules, this.excludes, this.exports, this.patches, this.reading, this.opens, new ClassPath(this.classPath, classPath));
    }

    public ClassPath getClassPath() {
        return this.classPath;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private static Set<String> toSet(Set<String> set, String[] modules) {
        Set<String> moduleSet;
        if (modules == null || modules.length == 0) {
            moduleSet = set;
        } else {
            moduleSet = new LinkedHashSet<String>(set);
            Arrays.stream(modules).filter(Objects::nonNull).forEach(moduleSet::add);
        }
        return moduleSet;
    }

    public JavaModules compose(JavaModules other) {
        LinkedHashSet<String> setAdd = new LinkedHashSet<String>(this.modules);
        LinkedHashSet<String> setExclude = new LinkedHashSet<String>(this.excludes);
        LinkedHashSet<String> setExport = new LinkedHashSet<String>(this.exports);
        LinkedHashSet<String> setPatch = new LinkedHashSet<String>(this.patches);
        LinkedHashSet<String> setReads = new LinkedHashSet<String>(this.reading);
        LinkedHashSet<String> setOpens = new LinkedHashSet<String>(this.opens);
        setAdd.addAll(other.modules);
        setExclude.addAll(other.excludes);
        setExport.addAll(other.exports);
        setPatch.addAll(other.patches);
        setReads.addAll(other.reading);
        setOpens.addAll(other.opens);
        boolean isEnabled = this.enabled && other.enabled;
        ClassPath classPath = new ClassPath(this.classPath, other.classPath);
        return new JavaModules(isEnabled, setAdd, setExclude, setExport, setPatch, setReads, setOpens, classPath);
    }

    @Override
    public Iterable<String> resolve(OptionsByType optionsByType) {
        ArrayList<String> opts = new ArrayList<String>();
        if (this.enabled) {
            String module;
            String[] parts;
            if (!this.modules.isEmpty()) {
                opts.add("--add-modules");
                if (this.excludes.isEmpty()) {
                    opts.add(String.join((CharSequence)",", this.modules));
                } else {
                    LinkedHashSet<String> set = new LinkedHashSet<String>(this.modules);
                    set.removeAll(this.excludes);
                    opts.add(String.join((CharSequence)",", set));
                }
            }
            if (!this.exports.isEmpty()) {
                if (this.excludes.isEmpty()) {
                    this.exports.forEach(export -> {
                        opts.add("--add-exports");
                        opts.add((String)export);
                    });
                } else {
                    for (String export2 : this.exports) {
                        String exportsToModules;
                        String[] targetParts;
                        parts = export2.split("/");
                        module = parts[0];
                        if (this.excludes.contains(module) || parts.length <= 1 || (targetParts = parts[1].split("=")).length <= 1 || (exportsToModules = Arrays.stream(targetParts[1].split(",")).filter(s -> !this.excludes.contains(s)).collect(Collectors.joining(","))).length() <= 0) continue;
                        opts.add("--add-exports");
                        opts.add(module + "/" + targetParts[0] + "=" + exportsToModules);
                    }
                }
            }
            if (!this.opens.isEmpty()) {
                if (this.excludes.isEmpty()) {
                    this.opens.forEach(open -> {
                        opts.add("--add-opens");
                        opts.add((String)open);
                    });
                } else {
                    for (String open2 : this.opens) {
                        String[] openParts;
                        parts = open2.split("/");
                        module = parts[0];
                        if (this.excludes.contains(module) || parts.length <= 1 || (openParts = parts[1].split("=")).length <= 1 || this.excludes.contains(openParts[1])) continue;
                        opts.add("--add-opens");
                        opts.add(open2);
                    }
                }
            }
            if (!this.patches.isEmpty()) {
                if (this.excludes.isEmpty()) {
                    this.patches.forEach(patch -> {
                        opts.add("--patch-module");
                        opts.add((String)patch);
                    });
                } else {
                    for (String patch2 : this.patches) {
                        String module2 = patch2.split("=")[0];
                        if (this.excludes.contains(module2)) continue;
                        opts.add("--patch-module");
                        opts.add(patch2);
                    }
                }
            }
            if (!this.reading.isEmpty()) {
                if (this.excludes.isEmpty()) {
                    this.reading.forEach(read -> {
                        opts.add("--add-reads");
                        opts.add((String)read);
                    });
                } else {
                    for (String reads : this.reading) {
                        String readsModules;
                        parts = reads.split("=");
                        module = parts[0];
                        if (this.excludes.contains(module) || parts.length <= 1 || (readsModules = Arrays.stream(parts[1].split(",")).filter(s -> !this.excludes.contains(s)).collect(Collectors.joining(","))).length() <= 0) continue;
                        opts.add("--add-reads");
                        opts.add(module + "=" + readsModules);
                    }
                }
            }
        }
        return opts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaModules modules1 = (JavaModules)o;
        if (this.enabled != modules1.enabled) {
            return false;
        }
        if (this.modules != null ? !this.modules.equals(modules1.modules) : modules1.modules != null) {
            return false;
        }
        if (this.excludes != null ? !this.excludes.equals(modules1.excludes) : modules1.excludes != null) {
            return false;
        }
        if (this.exports != null ? !this.exports.equals(modules1.exports) : modules1.exports != null) {
            return false;
        }
        if (this.patches != null ? !this.patches.equals(modules1.patches) : modules1.patches != null) {
            return false;
        }
        if (this.opens != null ? !this.opens.equals(modules1.opens) : modules1.opens != null) {
            return false;
        }
        return this.reading != null ? this.reading.equals(modules1.reading) : modules1.reading == null;
    }

    public int hashCode() {
        int result = this.enabled ? 1 : 0;
        result = 31 * result + (this.modules != null ? this.modules.hashCode() : 0);
        result = 31 * result + (this.excludes != null ? this.excludes.hashCode() : 0);
        result = 31 * result + (this.exports != null ? this.exports.hashCode() : 0);
        result = 31 * result + (this.patches != null ? this.patches.hashCode() : 0);
        result = 31 * result + (this.opens != null ? this.opens.hashCode() : 0);
        result = 31 * result + (this.reading != null ? this.reading.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "JavaModules(" + String.join((CharSequence)" ", this.resolve(OptionsByType.empty())) + ")";
    }
}

