/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java.io;

import com.oracle.bedrock.runtime.java.container.Container;
import com.oracle.bedrock.runtime.java.io.ClassLoaderAwareObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;

public class Serialization {
    public static byte[] toByteArray(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        boolean isSerializable = false;
        try {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeObject(object);
            isSerializable = true;
        }
        catch (IOException e) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        }
        if (!isSerializable) {
            objectOutputStream.writeBoolean(false);
            objectOutputStream.writeObject(object.getClass().getName());
        }
        objectOutputStream.flush();
        objectOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static <T> T fromByteArray(byte[] bytes, Class<T> clazz, ClassLoader classLoader) throws IOException {
        PrintStream stdout = Container.getPlatformScope().getStandardOutput();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        try (ClassLoaderAwareObjectInputStream objectInputStream = new ClassLoaderAwareObjectInputStream(classLoader, byteArrayInputStream);){
            Object object;
            boolean isSerializable = objectInputStream.readBoolean();
            if (isSerializable) {
                object = objectInputStream.readObject();
            } else {
                String clazzName = (String)objectInputStream.readObject();
                object = classLoader.loadClass(clazzName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if (object == null || clazz.isInstance(object)) {
                T t = clazz.cast(object);
                return t;
            }
            try {
                throw new ClassCastException("Expected " + clazz.getName() + ", Found " + object.getClass().getName() + "{" + String.valueOf(object) + "}");
            }
            catch (ClassCastException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("Failed to read underyling exception", e);
            }
        }
    }
}

