/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.console;

import com.oracle.bedrock.runtime.ApplicationConsole;
import com.oracle.bedrock.runtime.console.OutputRedirector;
import com.oracle.bedrock.runtime.java.container.Container;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintWriter;

public abstract class DefaultOutputRedirector
extends OutputRedirector {
    @Override
    public void start(String applicationName, String prefix, InputStream inputStream, ApplicationConsole console, long processId, boolean diagnosticsEnabled) {
        super.start(applicationName, prefix, inputStream, console, processId, diagnosticsEnabled);
    }

    protected abstract PrintWriter ensurePrintWriter();

    @Override
    public void run() {
        InputStream inputStream = this.getInputStream();
        String applicationName = this.getApplicationName();
        String prefix = this.getPrefix();
        long processId = this.getProcessId();
        ApplicationConsole console = this.getConsole();
        boolean diagnosticsEnabled = this.isDiagnosticsEnabled();
        boolean consoleDiagnosticsEnabled = console.isDiagnosticsEnabled();
        PrintWriter printWriter = this.ensurePrintWriter();
        long lineNumber = 1L;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(inputStream)));
            boolean running = true;
            while (running || reader.ready()) {
                try {
                    String line = reader.readLine();
                    if (line != null) {
                        String output;
                        String diagnosticOutput = diagnosticsEnabled || consoleDiagnosticsEnabled ? String.format("[%s:%s%s] %4d: %s", applicationName, prefix, processId < 0L ? "" : ":" + processId, lineNumber++, line) : null;
                        String string = output = consoleDiagnosticsEnabled ? diagnosticOutput : line;
                        if (diagnosticsEnabled) {
                            Container.getPlatformScope().getStandardOutput().println(output);
                        }
                        printWriter.println(output);
                        printWriter.flush();
                    }
                    break;
                }
                catch (InterruptedIOException e) {
                    running = false;
                }
            }
        }
        catch (Exception reader) {
            // empty catch block
        }
        try {
            String output;
            String diagnosticOutput = diagnosticsEnabled || consoleDiagnosticsEnabled ? String.format("[%s:%s%s] %4d: (terminated)", applicationName, prefix, processId < 0L ? "" : ":" + processId, lineNumber) : null;
            String string = output = consoleDiagnosticsEnabled ? diagnosticOutput : "(terminated)";
            if (diagnosticsEnabled) {
                Container.getPlatformScope().getStandardOutput().println(output);
            }
            printWriter.println(output);
            printWriter.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

