/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.concurrent.runnable;

import com.oracle.bedrock.runtime.concurrent.RemoteRunnable;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;

public class ThreadDump
implements RemoteRunnable {
    private boolean useStdOut;

    private ThreadDump(boolean useStdOut) {
        this.useStdOut = useStdOut;
    }

    @Override
    public void run() {
        if (this.useStdOut) {
            this.generateThreadDump(System.out);
        } else {
            this.generateThreadDump(System.err);
        }
    }

    public void generateThreadDump(PrintStream out) {
        ThreadInfo[] threadInfos;
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo threadInfo : threadInfos = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), 100)) {
            StackTraceElement[] stackTraceElements;
            out.print('\"');
            out.print(threadInfo.getThreadName());
            out.print("\" ");
            Thread.State state = threadInfo.getThreadState();
            out.print("\n   java.lang.Thread.State: ");
            out.print((Object)state);
            for (StackTraceElement stackTraceElement : stackTraceElements = threadInfo.getStackTrace()) {
                out.print("\n        at ");
                out.print(stackTraceElement);
            }
            out.print("\n");
        }
    }

    public static ThreadDump toStdOut() {
        return new ThreadDump(true);
    }

    public static ThreadDump toStdErr() {
        return new ThreadDump(false);
    }
}

