/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.concurrent;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.annotations.Internal;
import com.oracle.bedrock.lang.ThreadFactories;
import com.oracle.bedrock.options.Timeout;
import com.oracle.bedrock.runtime.concurrent.AbstractControllableRemoteChannel;
import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.oracle.bedrock.runtime.concurrent.RemoteChannel;
import com.oracle.bedrock.runtime.concurrent.RemoteChannelListener;
import com.oracle.bedrock.runtime.concurrent.RemoteEvent;
import com.oracle.bedrock.runtime.concurrent.RemoteRunnable;
import com.oracle.bedrock.runtime.concurrent.options.Caching;
import com.oracle.bedrock.runtime.concurrent.options.StreamName;
import com.oracle.bedrock.runtime.java.io.ClassLoaderAwareObjectInputStream;
import com.oracle.bedrock.util.Pair;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

@Internal
public abstract class AbstractRemoteChannel
extends AbstractControllableRemoteChannel {
    private static final Logger LOGGER = Logger.getLogger(AbstractRemoteChannel.class.getName());
    private final OutputStream underlyingOutput;
    private final InputStream underlyingInput;
    private ObjectOutputStream output;
    private ObjectInputStream input;
    private final ExecutorService sequentialExecutionService;
    private final ExecutorService concurrentExecutionService;
    private Thread requestAcceptorThread;
    private final AtomicBoolean isReadable;
    private final AtomicBoolean isWritable;
    private final HashMap<String, Class<? extends Operation>> protocol;
    private final ConcurrentHashMap<Long, Operation<?>> pendingOperations;
    private final AtomicLong nextSequenceNumber;
    private final ConcurrentHashMap<Callable<?>, Pair<Object, Instant>> cache;

    public AbstractRemoteChannel(OutputStream outputStream, InputStream inputStream) throws IOException {
        this.underlyingOutput = outputStream;
        this.underlyingInput = inputStream;
        this.output = this.underlyingOutput instanceof ObjectOutputStream ? (ObjectOutputStream)this.underlyingOutput : new ObjectOutputStream(this.underlyingOutput);
        this.output.flush();
        this.sequentialExecutionService = Executors.newSingleThreadExecutor(ThreadFactories.usingDaemonThreads((boolean)true));
        this.concurrentExecutionService = Executors.newCachedThreadPool(ThreadFactories.usingDaemonThreads((boolean)true));
        this.requestAcceptorThread = null;
        this.isReadable = new AtomicBoolean(true);
        this.isWritable = new AtomicBoolean(true);
        this.protocol = new HashMap();
        this.pendingOperations = new ConcurrentHashMap();
        this.nextSequenceNumber = new AtomicLong(0L);
        this.cache = new ConcurrentHashMap();
        this.protocol.put("CALLABLE", CallableOperation.class);
        this.protocol.put("RESPONSE", ResponseOperation.class);
        this.protocol.put("RUNNABLE", RunnableOperation.class);
        this.protocol.put("EVENT", EventOperation.class);
    }

    public ArrayList<String> getNetStatsInfo() {
        ArrayList<String> asPortInfo = new ArrayList<String>();
        try {
            Object line;
            String sOS = System.getProperty("os.name").toLowerCase();
            StringBuilder sbCommand = new StringBuilder().append("netstat ");
            if (sOS.contains("mac")) {
                sbCommand.append("-tanp tcp");
            } else if (sOS.contains("linux")) {
                sbCommand.append("-tanpve");
            } else if (sOS.contains("windows")) {
                sbCommand.append("-baonp tcp");
            }
            Process process = Runtime.getRuntime().exec(sbCommand.toString());
            InputStream in = process.getInputStream();
            BufferedReader buffer = new BufferedReader(new InputStreamReader(in));
            while ((line = buffer.readLine()) != null) {
                line = (String)line + System.lineSeparator();
                asPortInfo.add((String)line);
            }
            return asPortInfo;
        }
        catch (Exception e) {
            LOGGER.warning(this.getClass().getName() + ".getNetStatsInfo: unexpected Exception: " + e.getLocalizedMessage());
            return asPortInfo;
        }
    }

    public synchronized void open() {
        if (!this.isOpen()) {
            this.setOpen(true);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                this.input = new ClassLoaderAwareObjectInputStream(classLoader, this.underlyingInput);
            }
            catch (IOException e) {
                this.isReadable.set(false);
                this.setOpen(false);
                LOGGER.warning(this.getClass().getName() + ".open: unexpected IOException: " + e.getLocalizedMessage());
                LOGGER.info("netstats info: " + String.valueOf(this.getNetStatsInfo()));
                LOGGER.log(Level.FINE, "stack trace", e);
                return;
            }
            this.requestAcceptorThread = new Thread(() -> {
                while (this.isReadable.get() && this.isWritable.get()) {
                    try {
                        String operationType = this.input.readUTF();
                        long sequence = this.input.readLong();
                        int length = this.input.readInt();
                        byte[] bytes = new byte[length];
                        this.input.readFully(bytes, 0, length);
                        try {
                            ByteArrayInputStream buffer = new ByteArrayInputStream(bytes);
                            ClassLoaderAwareObjectInputStream stream = new ClassLoaderAwareObjectInputStream(classLoader, buffer);
                            Class<? extends Operation> operationClass = this.protocol.get(operationType);
                            Constructor<? extends Operation> constructor = operationClass.getConstructor(AbstractRemoteChannel.class);
                            Operation operation = constructor.newInstance(this);
                            operation.read(stream);
                            StreamName streamName = operation.getStreamName();
                            if (streamName == null) {
                                this.concurrentExecutionService.submit(new Executor(sequence, operation));
                                continue;
                            }
                            this.sequentialExecutionService.submit(new Executor(sequence, operation));
                        }
                        catch (Exception e) {
                            this.sequentialExecutionService.submit(new Sender(sequence, new ResponseOperation<Exception>(e)));
                        }
                    }
                    catch (Exception e) {
                        this.isReadable.set(false);
                        LOGGER.log(Level.FINE, "termination of RemoteChannel:RequestAcceptor thread", e);
                    }
                }
                this.close();
            });
            this.requestAcceptorThread.setName("RemoteChannel:RequestAcceptor");
            this.requestAcceptorThread.setDaemon(true);
            this.requestAcceptorThread.start();
            for (RemoteChannelListener listener : this.channelListeners) {
                try {
                    listener.onOpened(this);
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    protected void onClose() {
        this.isReadable.set(false);
        this.concurrentExecutionService.shutdown();
        this.sequentialExecutionService.shutdown();
        this.eventListenersByStreamName.clear();
        this.isWritable.set(false);
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.input = null;
        }
        try {
            if (this.output != null) {
                this.output.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.output = null;
        }
        for (Operation<?> operation : this.pendingOperations.values()) {
            try {
                operation.completeExceptionally(new IllegalStateException("RemoteChannel is closed"));
            }
            catch (Exception exception) {}
        }
        this.pendingOperations.clear();
    }

    @Override
    public <T> CompletableFuture<T> submit(RemoteCallable<T> callable, Option ... options) throws IllegalStateException {
        if (this.isOpen()) {
            OptionsByType optionsByType = OptionsByType.of((Option[])options);
            Caching caching = (Caching)optionsByType.get(Caching.class, new Object[0]);
            if (caching.isEnabled()) {
                Pair pair = this.cache.compute(callable, (c, existing) -> existing == null || ((Instant)existing.getY()).isBefore(Instant.now()) ? null : existing);
                if (pair != null) {
                    CompletableFuture<Object> future = new CompletableFuture<Object>();
                    future.complete(pair.getX());
                    return future;
                }
            } else {
                this.cache.remove(callable);
            }
            optionsByType.addIfAbsent((Option)RemoteChannel.AcknowledgeWhen.PROCESSED);
            CallableOperation<T> operation = new CallableOperation<T>(callable, optionsByType);
            return this.sendOperation(operation, optionsByType);
        }
        throw new IllegalStateException("RemoteChannel is closed");
    }

    @Override
    public CompletableFuture<Void> submit(RemoteRunnable runnable, Option ... options) throws IllegalStateException {
        if (this.isOpen()) {
            OptionsByType optionsByType = OptionsByType.of((Option[])options);
            optionsByType.addIfAbsent((Option)RemoteChannel.AcknowledgeWhen.SENT);
            RunnableOperation operation = new RunnableOperation(runnable, optionsByType);
            return this.sendOperation(operation, optionsByType);
        }
        throw new IllegalStateException("RemoteChannel is closed");
    }

    @Override
    public CompletableFuture<Void> raise(RemoteEvent event, Option ... options) {
        if (this.isOpen()) {
            OptionsByType optionsByType = OptionsByType.of((Option[])options);
            StreamName streamName = (StreamName)optionsByType.get(StreamName.class, new Object[0]);
            optionsByType.addIfAbsent((Option)RemoteChannel.AcknowledgeWhen.SENT);
            EventOperation operation = new EventOperation(streamName, event, optionsByType);
            return this.sendOperation(operation, optionsByType);
        }
        throw new IllegalStateException("RemoteChannel is closed");
    }

    private <T> CompletableFuture<T> sendOperation(Operation<T> operation, OptionsByType optionsByType) {
        long sequence = this.nextSequenceNumber.getAndIncrement();
        Sender sender = new Sender(sequence, operation);
        if (optionsByType.get(RemoteChannel.AcknowledgeWhen.class, new Object[0]) == RemoteChannel.AcknowledgeWhen.SENT) {
            return CompletableFuture.runAsync(sender, this.sequentialExecutionService).thenApply(_void -> null);
        }
        this.pendingOperations.put(sequence, operation);
        this.sequentialExecutionService.submit(sender);
        return operation.getCompletableFuture();
    }

    class CallableOperation<T>
    implements Operation<T> {
        private transient CompletableFuture<T> future;
        private transient OptionsByType optionsByType;
        private boolean isResponseRequired;
        private Callable<T> callable;

        public CallableOperation() {
        }

        public CallableOperation(Callable<T> callable, OptionsByType optionsByType) {
            Class<?> callableClass;
            Class<?> clazz = callableClass = callable == null ? null : callable.getClass();
            if (callableClass == null) {
                throw new NullPointerException("Callable can't be null");
            }
            if (callableClass.isAnonymousClass()) {
                throw new IllegalArgumentException("Callable can't be an anonymous inner-class");
            }
            if (callableClass.isMemberClass() && !Modifier.isStatic(callableClass.getModifiers())) {
                throw new IllegalArgumentException("Callable can't be an non-static inner-class");
            }
            this.isResponseRequired = optionsByType.get(RemoteChannel.AcknowledgeWhen.class, new Object[0]) == RemoteChannel.AcknowledgeWhen.PROCESSED;
            this.callable = callable;
            this.future = new CompletableFuture();
            this.optionsByType = optionsByType;
        }

        @Override
        public String getType() {
            return "CALLABLE";
        }

        @Override
        public Operation execute(long sequence) {
            ResponseOperation<Throwable> operation;
            block3: {
                operation = null;
                try {
                    AbstractRemoteChannel.this.injectInto(this.callable);
                    T result = this.callable.call();
                    if (this.isResponseRequired) {
                        operation = new ResponseOperation<T>(result);
                    }
                }
                catch (Throwable throwable) {
                    if (!this.isResponseRequired) break block3;
                    operation = new ResponseOperation<Throwable>(throwable);
                }
            }
            return operation;
        }

        @Override
        public void read(ObjectInputStream input) throws IOException {
            this.isResponseRequired = input.readBoolean();
            try {
                Object object = input.readObject();
                if (object instanceof String) {
                    String className = (String)object;
                    Class<?> callableClass = Class.forName(className);
                    this.callable = (Callable)callableClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                } else {
                    this.callable = (Callable)object;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void write(ObjectOutputStream output) throws IOException {
            output.writeBoolean(this.isResponseRequired);
            if (this.callable instanceof Serializable) {
                output.writeObject(this.callable);
            } else {
                output.writeObject(this.callable.getClass().getName());
            }
        }

        @Override
        public StreamName getStreamName() {
            return null;
        }

        @Override
        public void complete(T result) {
            Caching caching = (Caching)this.optionsByType.get(Caching.class, new Object[0]);
            if (caching.isEnabled()) {
                Timeout timeout = (Timeout)caching.getOptionsByType().get(Timeout.class, new Object[0]);
                Instant instant = Instant.now().plusMillis(timeout.to(TimeUnit.MILLISECONDS));
                AbstractRemoteChannel.this.cache.put(this.callable, (Pair<Object, Instant>)new Pair(result, (Object)instant));
            }
            this.future.complete(result);
        }

        @Override
        public void completeExceptionally(Throwable throwable) {
            this.future.completeExceptionally(throwable);
        }

        @Override
        public CompletableFuture<T> getCompletableFuture() {
            return this.future;
        }
    }

    class ResponseOperation<T>
    implements Operation<T> {
        private T response;

        public ResponseOperation() {
        }

        public ResponseOperation(T response) {
            this.response = response;
        }

        @Override
        public String getType() {
            return "RESPONSE";
        }

        @Override
        public Operation execute(long sequence) {
            Operation<?> operation = AbstractRemoteChannel.this.pendingOperations.remove(sequence);
            if (operation != null) {
                try {
                    if (this.response instanceof Throwable) {
                        operation.completeExceptionally((Throwable)this.response);
                    } else {
                        operation.complete(this.response);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public void read(ObjectInputStream input) throws IOException {
            try {
                this.response = input.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void write(ObjectOutputStream output) throws IOException {
            output.writeObject(this.response);
        }

        public String toString() {
            return "ResponseOperation{response=" + String.valueOf(this.response) + "}";
        }

        @Override
        public StreamName getStreamName() {
            return null;
        }

        @Override
        public void complete(T result) {
        }

        @Override
        public void completeExceptionally(Throwable throwable) {
        }

        @Override
        public CompletableFuture<T> getCompletableFuture() {
            return null;
        }
    }

    class RunnableOperation
    implements Operation<Void> {
        private transient CompletableFuture<Void> future;
        private Runnable runnable;
        private boolean isResponseRequired;

        public RunnableOperation() {
        }

        public RunnableOperation(Runnable runnable, OptionsByType optionsByType) {
            Class<?> runnableClass;
            Class<?> clazz = runnableClass = runnable == null ? null : runnable.getClass();
            if (runnableClass == null) {
                throw new NullPointerException("Runnable can't be null");
            }
            if (runnableClass.isAnonymousClass()) {
                throw new IllegalArgumentException("Runnable can't be an anonymous inner-class");
            }
            if (runnableClass.isMemberClass() && !Modifier.isStatic(runnableClass.getModifiers())) {
                throw new IllegalArgumentException("Runnable can't be an non-static inner-class");
            }
            this.runnable = runnable;
            this.isResponseRequired = optionsByType.get(RemoteChannel.AcknowledgeWhen.class, new Object[0]) == RemoteChannel.AcknowledgeWhen.PROCESSED;
            this.future = new CompletableFuture();
        }

        @Override
        public String getType() {
            return "RUNNABLE";
        }

        @Override
        public Operation execute(long sequence) {
            ResponseOperation<Throwable> response;
            block3: {
                response = null;
                try {
                    AbstractRemoteChannel.this.injectInto(this.runnable);
                    this.runnable.run();
                    if (this.isResponseRequired) {
                        response = new ResponseOperation<Object>(null);
                    }
                }
                catch (Throwable throwable) {
                    if (!this.isResponseRequired) break block3;
                    response = new ResponseOperation<Throwable>(throwable);
                }
            }
            return response;
        }

        @Override
        public void read(ObjectInputStream input) throws IOException {
            this.isResponseRequired = input.readBoolean();
            try {
                Object object = input.readObject();
                if (object instanceof String) {
                    String className = (String)object;
                    this.runnable = (Runnable)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                } else {
                    this.runnable = (Runnable)object;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void write(ObjectOutputStream output) throws IOException {
            output.writeBoolean(this.isResponseRequired);
            if (this.runnable instanceof Serializable) {
                output.writeObject(this.runnable);
            } else {
                output.writeObject(this.runnable.getClass().getName());
            }
        }

        @Override
        public StreamName getStreamName() {
            return null;
        }

        @Override
        public void complete(Void result) {
            this.future.complete(result);
        }

        @Override
        public void completeExceptionally(Throwable throwable) {
            this.future.completeExceptionally(throwable);
        }

        @Override
        public CompletableFuture<Void> getCompletableFuture() {
            return this.future;
        }
    }

    class EventOperation
    implements Operation<Void> {
        private transient CompletableFuture<Void> future;
        private transient OptionsByType optionsByType;
        private StreamName streamName;
        private RemoteEvent event;
        private boolean isAckRequired;

        public EventOperation() {
        }

        public EventOperation(StreamName streamName, RemoteEvent event, OptionsByType optionsByType) {
            if (streamName == null) {
                throw new NullPointerException("The streamName can't be null");
            }
            if (event == null) {
                throw new NullPointerException("RemoteEvent can't be null");
            }
            if (event.getClass().isAnonymousClass()) {
                throw new IllegalArgumentException("RemoteEvent can't be an anonymous inner-class");
            }
            this.streamName = streamName;
            this.isAckRequired = optionsByType.get(RemoteChannel.AcknowledgeWhen.class, new Object[0]) == RemoteChannel.AcknowledgeWhen.PROCESSED;
            this.event = event;
            this.future = new CompletableFuture();
            this.optionsByType = optionsByType;
        }

        @Override
        public String getType() {
            return "EVENT";
        }

        @Override
        public Operation execute(long sequence) {
            Set eventListeners = (Set)AbstractRemoteChannel.this.eventListenersByStreamName.get(this.streamName);
            if (eventListeners != null) {
                eventListeners.forEach(eventListener -> {
                    try {
                        eventListener.onEvent(this.event);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                });
            }
            return this.isAckRequired ? new ResponseOperation<Object>(null) : null;
        }

        @Override
        public void read(ObjectInputStream input) throws IOException {
            try {
                this.streamName = StreamName.of(input.readUTF());
                this.isAckRequired = input.readBoolean();
                Object object = input.readObject();
                if (object instanceof String) {
                    String className = (String)object;
                    this.event = (RemoteEvent)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                } else {
                    this.event = (RemoteEvent)object;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void write(ObjectOutputStream output) throws IOException {
            output.writeUTF(this.streamName.get());
            output.writeBoolean(this.isAckRequired);
            if (this.event instanceof Serializable) {
                output.writeObject(this.event);
            } else {
                output.writeObject(this.event.getClass().getName());
            }
        }

        @Override
        public StreamName getStreamName() {
            return this.streamName;
        }

        @Override
        public void complete(Void result) {
            this.future.complete(result);
        }

        @Override
        public void completeExceptionally(Throwable throwable) {
            this.future.completeExceptionally(throwable);
        }

        @Override
        public CompletableFuture<Void> getCompletableFuture() {
            return this.future;
        }
    }

    static interface Operation<T> {
        public String getType();

        public void write(ObjectOutputStream var1) throws IOException;

        public void read(ObjectInputStream var1) throws IOException;

        public Operation execute(long var1);

        public StreamName getStreamName();

        public void complete(T var1);

        public void completeExceptionally(Throwable var1);

        public CompletableFuture<T> getCompletableFuture();
    }

    class Sender
    implements Runnable {
        private final long sequence;
        private final Operation operation;

        public Sender(long sequence, Operation operation) {
            this.sequence = sequence;
            this.operation = operation;
        }

        @Override
        public void run() {
            try {
                boolean sendTemporaryStream;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream(4096);
                ObjectOutputStream stream = new ObjectOutputStream(buffer);
                try {
                    this.operation.write(stream);
                    sendTemporaryStream = true;
                }
                catch (NotSerializableException e) {
                    Operation<?> operation = AbstractRemoteChannel.this.pendingOperations.remove(this.sequence);
                    if (operation == null) {
                        sendTemporaryStream = true;
                        buffer.reset();
                        stream = new ObjectOutputStream(buffer);
                        operation = new ResponseOperation<NotSerializableException>(e);
                        operation.write(stream);
                    }
                    sendTemporaryStream = false;
                    operation.completeExceptionally(e);
                }
                if (sendTemporaryStream) {
                    stream.flush();
                    AbstractRemoteChannel.this.output.writeUTF(this.operation.getType());
                    AbstractRemoteChannel.this.output.writeLong(this.sequence);
                    byte[] array = buffer.toByteArray();
                    AbstractRemoteChannel.this.output.writeInt(array.length);
                    AbstractRemoteChannel.this.output.write(array, 0, array.length);
                    AbstractRemoteChannel.this.output.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class Executor
    implements Runnable {
        private final long sequence;
        private final Operation operation;

        public Executor(long sequence, Operation operation) {
            this.sequence = sequence;
            this.operation = operation;
        }

        @Override
        public void run() {
            Operation resultingOperation = this.operation.execute(this.sequence);
            if (resultingOperation != null) {
                AbstractRemoteChannel.this.sequentialExecutionService.submit(new Sender(this.sequence, resultingOperation));
            }
        }
    }
}

