/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.saml2.logout;

import com.onelogin.saml2.model.SamlResponseStatus;

public class LogoutResponseParams {
    private final String inResponseTo;
    private final SamlResponseStatus responseStatus;

    public LogoutResponseParams() {
        this((String)null);
    }

    public LogoutResponseParams(String inResponseTo) {
        this(inResponseTo, "urn:oasis:names:tc:SAML:2.0:status:Success");
    }

    public LogoutResponseParams(String inResponseTo, String statusCode) {
        this(inResponseTo, new SamlResponseStatus(statusCode));
    }

    public LogoutResponseParams(String inResponseTo, SamlResponseStatus responseStatus) throws NullPointerException {
        this.inResponseTo = inResponseTo;
        this.responseStatus = responseStatus;
        if (responseStatus == null) {
            throw new NullPointerException("response status must not be null");
        }
    }

    protected LogoutResponseParams(LogoutResponseParams source) {
        this.inResponseTo = source.getInResponseTo();
        this.responseStatus = source.getResponseStatus();
    }

    public SamlResponseStatus getResponseStatus() {
        return this.responseStatus;
    }

    public String getInResponseTo() {
        return this.inResponseTo;
    }
}

