/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.plot;

import com.orsoncharts.Colors;
import com.orsoncharts.data.DefaultKeyedValues;
import com.orsoncharts.plot.ColorSource;
import com.orsoncharts.util.ArgChecks;
import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;

public final class StandardColorSource
implements ColorSource,
Serializable {
    private Color[] standardColors;
    private DefaultKeyedValues<Color> colors;

    public StandardColorSource() {
        this(Colors.getDefaultColors());
    }

    public StandardColorSource(Color ... colors) {
        ArgChecks.nullNotPermitted(colors, "colors");
        if (colors.length == 0) {
            throw new IllegalArgumentException("Zero length array not permitted.");
        }
        for (Color c : colors) {
            if (c != null) continue;
            throw new IllegalArgumentException("Null array entries not permitted.");
        }
        this.standardColors = (Color[])colors.clone();
        this.colors = new DefaultKeyedValues();
    }

    @Override
    public Color getColor(Comparable<?> key) {
        Color c = this.colors.getValue(key);
        if (c != null) {
            return c;
        }
        c = this.standardColors[this.colors.getItemCount() % this.standardColors.length];
        this.colors.put(key, c);
        return c;
    }

    @Override
    public void setColor(Comparable<?> key, Color color) {
        if (color != null) {
            this.colors.put(key, color);
        } else {
            this.colors.remove(key);
        }
    }

    @Override
    public void style(Color ... colors) {
        this.standardColors = colors;
        this.colors.clear();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardColorSource)) {
            return false;
        }
        StandardColorSource that = (StandardColorSource)obj;
        if (!Arrays.equals(this.standardColors, that.standardColors)) {
            return false;
        }
        return this.colors.equals(that.colors);
    }
}

