/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.fx;

import com.orsoncharts.Chart3D;
import com.orsoncharts.Chart3DChangeEvent;
import com.orsoncharts.Chart3DChangeListener;
import com.orsoncharts.data.ItemKey;
import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.graphics3d.Object3D;
import com.orsoncharts.graphics3d.Offset2D;
import com.orsoncharts.graphics3d.RenderingInfo;
import com.orsoncharts.graphics3d.ViewPoint3D;
import com.orsoncharts.util.ArgChecks;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import org.jfree.fx.FXGraphics2D;

public class Chart3DCanvas
extends Canvas
implements Chart3DChangeListener {
    private Chart3D chart;
    private Graphics2D g2;
    private RenderingInfo renderingInfo;
    private double minViewingDistance;
    private double maxViewingDistanceMultiplier;
    private double margin = 0.25;
    private double panIncrement = 0.02617993877991494;
    private double rotateIncrement = 0.02617993877991494;
    private Point lastClickPoint;
    private Point lastMovePoint;
    private Offset2D offsetAtMousePressed;
    private Tooltip tooltip;
    private boolean tooltipEnabled = true;
    private boolean rotateViewEnabled = true;

    public Chart3DCanvas(Chart3D chart) {
        this.chart = chart;
        this.minViewingDistance = chart.getDimensions().getDiagonalLength();
        this.maxViewingDistanceMultiplier = 8.0;
        this.widthProperty().addListener(e -> this.draw());
        this.heightProperty().addListener(e -> this.draw());
        this.g2 = new FXGraphics2D(this.getGraphicsContext2D());
        this.setOnMouseMoved(me -> this.updateTooltip((MouseEvent)me));
        this.setOnMousePressed(me -> {
            Chart3DCanvas canvas = this;
            canvas.lastMovePoint = canvas.lastClickPoint = new Point((int)me.getScreenX(), (int)me.getScreenY());
        });
        this.setOnMouseDragged(me -> this.handleMouseDragged((MouseEvent)me));
        this.setOnScroll(event -> this.handleScroll((ScrollEvent)event));
        this.chart.addChangeListener(this);
    }

    public Chart3D getChart() {
        return this.chart;
    }

    public void setChart(Chart3D chart) {
        ArgChecks.nullNotPermitted(chart, "chart");
        if (this.chart != null) {
            this.chart.removeChangeListener(this);
        }
        this.chart = chart;
        this.chart.addChangeListener(this);
        this.draw();
    }

    public double getMargin() {
        return this.margin;
    }

    public void setMargin(double margin) {
        this.margin = margin;
    }

    public RenderingInfo getRenderingInfo() {
        return this.renderingInfo;
    }

    public double getMinViewingDistance() {
        return this.minViewingDistance;
    }

    public void setMinViewingDistance(double minViewingDistance) {
        this.minViewingDistance = minViewingDistance;
        if (this.chart.getViewPoint().getRho() < this.minViewingDistance) {
            this.chart.getViewPoint().setRho(this.minViewingDistance);
        }
    }

    public double getMaxViewingDistanceMultiplier() {
        return this.maxViewingDistanceMultiplier;
    }

    public void setMaxViewingDistanceMultiplier(double multiplier) {
        if (multiplier < 1.0) {
            throw new IllegalArgumentException("The 'multiplier' should be greater than 1.0.");
        }
        this.maxViewingDistanceMultiplier = multiplier;
        double maxDistance = this.minViewingDistance * multiplier;
        if (this.chart.getViewPoint().getRho() > maxDistance) {
            this.chart.getViewPoint().setRho(maxDistance);
        }
    }

    public double getPanIncrement() {
        return this.panIncrement;
    }

    public void setPanIncrement(double increment) {
        this.panIncrement = increment;
    }

    public double getRotateIncrement() {
        return this.rotateIncrement;
    }

    public void setRotateIncrement(double increment) {
        this.rotateIncrement = increment;
    }

    public boolean isTooltipEnabled() {
        return this.tooltipEnabled;
    }

    public void setTooltipEnabled(boolean tooltipEnabled) {
        this.tooltipEnabled = tooltipEnabled;
    }

    public boolean isRotateViewEnabled() {
        return this.rotateViewEnabled;
    }

    public void setRotateViewEnabled(boolean enabled) {
        this.rotateViewEnabled = enabled;
    }

    public void zoomToFit(double width, double height) {
        int w = (int)(width * (1.0 - this.margin));
        int h = (int)(height * (1.0 - this.margin));
        Dimension target = new Dimension(w, h);
        Dimension3D d3d = this.chart.getDimensions();
        float distance = this.chart.getViewPoint().optimalDistance(target, d3d, this.chart.getProjDistance());
        this.chart.getViewPoint().setRho(distance);
        this.draw();
    }

    public void draw() {
        GraphicsContext ctx = this.getGraphicsContext2D();
        ctx.save();
        double width = this.getWidth();
        double height = this.getHeight();
        if (width > 0.0 && height > 0.0) {
            ctx.clearRect(0.0, 0.0, width, height);
            this.renderingInfo = this.chart.draw(this.g2, new Rectangle((int)width, (int)height));
        }
        ctx.restore();
    }

    public boolean isResizable() {
        return true;
    }

    protected void updateTooltip(MouseEvent me) {
        if (!this.tooltipEnabled || this.renderingInfo == null) {
            return;
        }
        Object3D object = this.renderingInfo.fetchObjectAt(me.getX(), me.getY());
        if (object != null) {
            ItemKey key = (ItemKey)object.getProperty("key");
            if (key != null) {
                String toolTipText = this.chart.getPlot().generateToolTipText(key);
                if (this.tooltip == null) {
                    this.tooltip = new Tooltip(toolTipText);
                    Tooltip.install((Node)this, (Tooltip)this.tooltip);
                } else {
                    this.tooltip.setText(toolTipText);
                    this.tooltip.setAnchorX(me.getScreenX());
                    this.tooltip.setAnchorY(me.getScreenY());
                }
            } else {
                if (this.tooltip != null) {
                    Tooltip.uninstall((Node)this, (Tooltip)this.tooltip);
                }
                this.tooltip = null;
            }
        }
    }

    private void handleMouseDragged(MouseEvent event) {
        if (!this.rotateViewEnabled) {
            return;
        }
        Point currPt = new Point((int)event.getScreenX(), (int)event.getScreenY());
        int dx = currPt.x - this.lastMovePoint.x;
        int dy = currPt.y - this.lastMovePoint.y;
        this.lastMovePoint = currPt;
        this.chart.getViewPoint().panLeftRight((double)(-dx) * this.panIncrement);
        this.chart.getViewPoint().moveUpDown((double)(-dy) * this.rotateIncrement);
        this.draw();
    }

    private void handleScroll(ScrollEvent event) {
        double units = -event.getDeltaY();
        double maxViewingDistance = this.maxViewingDistanceMultiplier * this.minViewingDistance;
        ViewPoint3D vp = this.chart.getViewPoint();
        double valRho = Math.max(this.minViewingDistance, Math.min(maxViewingDistance, vp.getRho() + units));
        vp.setRho(valRho);
        this.draw();
    }

    @Override
    public void chartChanged(Chart3DChangeEvent event) {
        this.draw();
    }
}

