/*
 * Decompiled with CFR 0.152.
 */
package com.ninja_squad.dbsetup.operation;

import com.ninja_squad.dbsetup.bind.BinderConfiguration;
import com.ninja_squad.dbsetup.operation.CompositeOperation;
import com.ninja_squad.dbsetup.operation.Operation;
import com.ninja_squad.dbsetup.util.Preconditions;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SqlOperation
implements Operation {
    private final String sql;

    private SqlOperation(String sql) {
        Preconditions.checkNotNull(sql, "sql may not be null");
        this.sql = sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Connection connection, BinderConfiguration configuration) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.executeUpdate(this.sql);
        }
    }

    public static SqlOperation of(@Nonnull String sqlStatement) {
        return new SqlOperation(sqlStatement);
    }

    public static Operation of(String ... sqlStatements) {
        return SqlOperation.of(Arrays.asList(sqlStatements));
    }

    public static Operation of(@Nonnull List<String> sqlStatements) {
        ArrayList<SqlOperation> operations = new ArrayList<SqlOperation>(sqlStatements.size());
        for (String sql : sqlStatements) {
            operations.add(new SqlOperation(sql));
        }
        return CompositeOperation.sequenceOf(operations);
    }

    public String toString() {
        return this.sql;
    }

    public int hashCode() {
        return this.sql.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        SqlOperation other = (SqlOperation)o;
        return this.sql.equals(other.sql);
    }
}

