/*
 * Decompiled with CFR 0.152.
 */
package com.ninja_squad.dbsetup.operation;

import com.ninja_squad.dbsetup.bind.BinderConfiguration;
import com.ninja_squad.dbsetup.operation.CompositeOperation;
import com.ninja_squad.dbsetup.operation.Operation;
import com.ninja_squad.dbsetup.util.Preconditions;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class DeleteAll
implements Operation {
    private final String table;

    private DeleteAll(String table) {
        Preconditions.checkNotNull(table, "table may not be null");
        this.table = table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Connection connection, BinderConfiguration configuration) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.executeUpdate("delete from " + this.table);
        }
    }

    public static DeleteAll from(@Nonnull String table) {
        return new DeleteAll(table);
    }

    public static Operation from(String ... tables) {
        return DeleteAll.from(Arrays.asList(tables));
    }

    public static Operation from(@Nonnull List<String> tables) {
        ArrayList<DeleteAll> operations = new ArrayList<DeleteAll>(tables.size());
        for (String table : tables) {
            operations.add(new DeleteAll(table));
        }
        return CompositeOperation.sequenceOf(operations);
    }

    public String toString() {
        return "delete from " + this.table;
    }

    public int hashCode() {
        return this.table.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeleteAll other = (DeleteAll)obj;
        return this.table.equals(other.table);
    }
}

