/*
 * Decompiled with CFR 0.152.
 */
package com.ninja_squad.dbsetup.generator;

import com.ninja_squad.dbsetup.generator.ValueGenerator;
import com.ninja_squad.dbsetup.util.Preconditions;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.Nonnull;

public final class DateSequenceValueGenerator
implements ValueGenerator<ZonedDateTime> {
    private static final int MIN_NUMBER_OF_CHARS_FOR_TIMESTAMP = 19;
    private ZonedDateTime next;
    private int increment;
    private TemporalUnit unit;

    DateSequenceValueGenerator() {
        this(LocalDate.now().atStartOfDay().atZone(ZoneId.systemDefault()), 1, ChronoUnit.DAYS);
    }

    private DateSequenceValueGenerator(ZonedDateTime next, int increment, TemporalUnit unit) {
        this.next = next;
        this.increment = increment;
        this.unit = unit;
    }

    @Deprecated
    public DateSequenceValueGenerator startingAt(@Nonnull Date startDate, @Nonnull TimeZone timeZone) {
        Preconditions.checkNotNull(startDate, "startDate may not be null");
        Preconditions.checkNotNull(timeZone, "timeZone may not be null");
        this.next = startDate.toInstant().atZone(timeZone.toZoneId());
        return this;
    }

    @Deprecated
    public DateSequenceValueGenerator startingAt(@Nonnull Date startDate) {
        return this.startingAt(startDate, TimeZone.getDefault());
    }

    @Deprecated
    public DateSequenceValueGenerator startingAt(@Nonnull Calendar startDate) {
        Preconditions.checkNotNull(startDate, "startDate may not be null");
        this.next = startDate.toInstant().atZone(startDate.getTimeZone().toZoneId());
        return this;
    }

    public DateSequenceValueGenerator startingAt(@Nonnull String startDate) {
        Preconditions.checkNotNull(startDate, "startDate may not be null");
        if (startDate.length() >= 19) {
            return this.startingAt(new Date(Timestamp.valueOf(startDate).getTime()));
        }
        return this.startingAt(new Date(java.sql.Date.valueOf(startDate).getTime()));
    }

    public DateSequenceValueGenerator startingAt(@Nonnull LocalDate startDate) {
        return this.startingAt(startDate.atStartOfDay());
    }

    public DateSequenceValueGenerator startingAt(@Nonnull LocalDateTime startDate) {
        return this.startingAt(startDate.atZone(ZoneId.systemDefault()));
    }

    public DateSequenceValueGenerator startingAt(@Nonnull ZonedDateTime startDate) {
        this.next = startDate;
        return this;
    }

    @Deprecated
    public DateSequenceValueGenerator incrementingBy(int increment, @Nonnull CalendarField unit) {
        Preconditions.checkNotNull((Object)unit, "unit may not be null");
        return this.incrementingBy(increment, unit.toTemporalUnit());
    }

    public DateSequenceValueGenerator incrementingBy(int increment, @Nonnull TemporalUnit unit) {
        Preconditions.checkNotNull(unit, "unit may not be null");
        this.increment = increment;
        this.unit = unit;
        return this;
    }

    @Override
    public ZonedDateTime nextValue() {
        ZonedDateTime result = this.next;
        this.next = this.next.plus(this.increment, this.unit);
        return result;
    }

    public String toString() {
        return "DateSequenceValueGenerator[next=" + this.next + ", increment=" + this.increment + ", unit=" + this.unit + "]";
    }

    @Deprecated
    public static enum CalendarField {
        YEAR(ChronoUnit.YEARS),
        MONTH(ChronoUnit.MONTHS),
        DAY(ChronoUnit.DAYS),
        HOUR(ChronoUnit.HOURS),
        MINUTE(ChronoUnit.MINUTES),
        SECOND(ChronoUnit.SECONDS),
        MILLISECOND(ChronoUnit.MILLIS);

        private TemporalUnit unit;

        private CalendarField(TemporalUnit unit) {
            this.unit = unit;
        }

        private TemporalUnit toTemporalUnit() {
            return this.unit;
        }
    }
}

