/*
 * Decompiled with CFR 0.152.
 */
package com.ninja_squad.dbsetup;

import com.ninja_squad.dbsetup.DbSetup;
import javax.annotation.Nonnull;

public final class DbSetupTracker {
    private DbSetup lastSetupLaunched;
    private boolean nextLaunchSkipped;

    public void launchIfNecessary(@Nonnull DbSetup dbSetup) {
        boolean skipLaunch = this.nextLaunchSkipped && dbSetup.equals(this.lastSetupLaunched);
        this.nextLaunchSkipped = false;
        if (skipLaunch) {
            return;
        }
        dbSetup.launch();
        this.lastSetupLaunched = dbSetup;
    }

    public void skipNextLaunch() {
        this.nextLaunchSkipped = true;
    }

    public String toString() {
        return "DbSetupTracker [lastSetupLaunched=" + this.lastSetupLaunched + ", nextLaunchSkipped=" + this.nextLaunchSkipped + "]";
    }
}

