/*
 * Decompiled with CFR 0.152.
 */
package com.ninja_squad.dbsetup;

import com.ninja_squad.dbsetup.DbSetupRuntimeException;
import com.ninja_squad.dbsetup.bind.BinderConfiguration;
import com.ninja_squad.dbsetup.bind.DefaultBinderConfiguration;
import com.ninja_squad.dbsetup.destination.Destination;
import com.ninja_squad.dbsetup.operation.Operation;
import com.ninja_squad.dbsetup.util.Preconditions;
import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.Nonnull;

public final class DbSetup {
    private final Destination destination;
    private final Operation operation;
    private final BinderConfiguration binderConfiguration;

    public DbSetup(@Nonnull Destination destination, @Nonnull Operation operation) {
        this(destination, operation, DefaultBinderConfiguration.INSTANCE);
    }

    public DbSetup(@Nonnull Destination destination, @Nonnull Operation operation, @Nonnull BinderConfiguration binderConfiguration) {
        Preconditions.checkNotNull(destination, "destination may not be null");
        Preconditions.checkNotNull(operation, "operation may not be null");
        Preconditions.checkNotNull(binderConfiguration, "binderConfiguration may not be null");
        this.destination = destination;
        this.operation = operation;
        this.binderConfiguration = binderConfiguration;
    }

    public void launch() {
        try (Connection connection = this.destination.getConnection();){
            connection.setAutoCommit(false);
            this.operation.execute(connection, this.binderConfiguration);
            connection.commit();
        }
        catch (SQLException e) {
            throw new DbSetupRuntimeException(e);
        }
    }

    public String toString() {
        return "DbSetup [destination=" + this.destination + ", operation=" + this.operation + ", binderConfiguration=" + this.binderConfiguration + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.binderConfiguration.hashCode();
        result = 31 * result + this.destination.hashCode();
        result = 31 * result + this.operation.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DbSetup other = (DbSetup)obj;
        return this.binderConfiguration.equals(other.binderConfiguration) && this.destination.equals(other.destination) && this.operation.equals(other.operation);
    }
}

