/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer;

import com.netflix.loadbalancer.AbstractLoadBalancer;
import com.netflix.loadbalancer.ClientConfigEnabledRoundRobinRule;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.LoadBalancerStats;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerStats;
import java.util.List;

public class BestAvailableRule
extends ClientConfigEnabledRoundRobinRule {
    private LoadBalancerStats loadBalancerStats;

    @Override
    public Server choose(Object key) {
        if (this.loadBalancerStats == null) {
            return super.choose(key);
        }
        List<Server> serverList = this.getLoadBalancer().getAllServers();
        int minimalConcurrentConnections = Integer.MAX_VALUE;
        long currentTime = System.currentTimeMillis();
        Server chosen = null;
        for (Server server : serverList) {
            int concurrentConnections;
            ServerStats serverStats = this.loadBalancerStats.getSingleServerStat(server);
            if (serverStats.isCircuitBreakerTripped(currentTime) || (concurrentConnections = serverStats.getActiveRequestsCount(currentTime)) >= minimalConcurrentConnections) continue;
            minimalConcurrentConnections = concurrentConnections;
            chosen = server;
        }
        if (chosen == null) {
            return super.choose(key);
        }
        return chosen;
    }

    @Override
    public void setLoadBalancer(ILoadBalancer lb) {
        super.setLoadBalancer(lb);
        if (lb instanceof AbstractLoadBalancer) {
            this.loadBalancerStats = ((AbstractLoadBalancer)lb).getLoadBalancerStats();
        }
    }
}

