/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.monitor;

import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.event.PluginPublisher;
import com.nepxion.discovery.plugin.strategy.context.StrategyContextHolder;
import com.nepxion.discovery.plugin.strategy.event.StrategyAlarmEvent;
import com.nepxion.discovery.plugin.strategy.monitor.StrategyAlarm;
import com.nepxion.discovery.plugin.strategy.monitor.StrategyMonitorContext;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class DefaultStrategyAlarm
implements StrategyAlarm {
    @Autowired
    protected PluginAdapter pluginAdapter;
    @Autowired
    protected StrategyContextHolder strategyContextHolder;
    @Autowired
    protected StrategyMonitorContext strategyMonitorContext;
    @Autowired
    protected PluginPublisher pluginPublisher;
    @Value(value="${spring.application.strategy.alarm.enabled:false}")
    protected Boolean alarmEnabled;

    @Override
    public void alarm() {
        Map<String, String> customizationMap;
        String addressBlacklist;
        String idBlacklist;
        String routeRegionWeight;
        String routeVersionWeight;
        String routeAddress;
        String routeEnvironment;
        String routeRegion;
        if (!this.alarmEnabled.booleanValue()) {
            return;
        }
        LinkedHashMap<String, String> contextMap = new LinkedHashMap<String, String>();
        String traceId = this.strategyMonitorContext.getTraceId();
        String spanId = this.strategyMonitorContext.getSpanId();
        contextMap.put("trace-id", StringUtils.isNotEmpty((CharSequence)traceId) ? traceId : "");
        contextMap.put("span-id", StringUtils.isNotEmpty((CharSequence)spanId) ? spanId : "");
        contextMap.put("n-d-service-group", this.pluginAdapter.getGroup());
        contextMap.put("n-d-service-type", this.pluginAdapter.getServiceType());
        String serviceAppId = this.pluginAdapter.getServiceAppId();
        if (StringUtils.isNotEmpty((CharSequence)serviceAppId)) {
            contextMap.put("n-d-service-app-id", serviceAppId);
        }
        contextMap.put("n-d-service-id", this.pluginAdapter.getServiceId());
        contextMap.put("n-d-service-address", this.pluginAdapter.getHost() + ":" + this.pluginAdapter.getPort());
        contextMap.put("n-d-service-version", this.pluginAdapter.getVersion());
        contextMap.put("n-d-service-region", this.pluginAdapter.getRegion());
        contextMap.put("n-d-service-env", this.pluginAdapter.getEnvironment());
        contextMap.put("n-d-service-zone", this.pluginAdapter.getZone());
        String routeVersion = this.strategyContextHolder.getHeader("n-d-version");
        if (StringUtils.isNotEmpty((CharSequence)routeVersion)) {
            contextMap.put("n-d-version", routeVersion);
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeRegion = this.strategyContextHolder.getHeader("n-d-region")))) {
            contextMap.put("n-d-region", routeRegion);
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeEnvironment = this.strategyContextHolder.getHeader("n-d-env")))) {
            contextMap.put("n-d-env", routeEnvironment);
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeAddress = this.strategyContextHolder.getHeader("n-d-address")))) {
            contextMap.put("n-d-address", routeAddress);
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeVersionWeight = this.strategyContextHolder.getHeader("n-d-version-weight")))) {
            contextMap.put("n-d-version-weight", routeVersionWeight);
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeRegionWeight = this.strategyContextHolder.getHeader("n-d-region-weight")))) {
            contextMap.put("n-d-region-weight", routeRegionWeight);
        }
        if (StringUtils.isNotEmpty((CharSequence)(idBlacklist = this.strategyContextHolder.getHeader("n-d-id-blacklist")))) {
            contextMap.put("n-d-id-blacklist", idBlacklist);
        }
        if (StringUtils.isNotEmpty((CharSequence)(addressBlacklist = this.strategyContextHolder.getHeader("n-d-address-blacklist")))) {
            contextMap.put("n-d-address-blacklist", addressBlacklist);
        }
        if (MapUtils.isNotEmpty(customizationMap = this.strategyMonitorContext.getCustomizationMap())) {
            contextMap.putAll(customizationMap);
        }
        this.onAlarm(contextMap);
    }

    private void onAlarm(Map<String, String> alarmMap) {
        this.pluginPublisher.asyncPublish((Object)new StrategyAlarmEvent("strategy-context-alarm", alarmMap));
    }
}

