/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.monitor;

import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.strategy.context.StrategyContextHolder;
import com.nepxion.discovery.plugin.strategy.monitor.StrategyMonitorContext;
import com.nepxion.discovery.plugin.strategy.monitor.StrategyTracer;
import com.nepxion.discovery.plugin.strategy.monitor.StrategyTracerContext;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public abstract class AbstractStrategyTracer<S>
implements StrategyTracer {
    @Autowired
    protected PluginAdapter pluginAdapter;
    @Autowired
    protected StrategyContextHolder strategyContextHolder;
    @Autowired
    protected StrategyMonitorContext strategyMonitorContext;
    @Value(value="${spring.application.strategy.tracer.enabled:false}")
    protected Boolean tracerEnabled;
    @Value(value="${spring.application.strategy.tracer.separate.span.enabled:true}")
    protected Boolean tracerSeparateSpanEnabled;
    @Value(value="${spring.application.strategy.tracer.rule.output.enabled:true}")
    protected Boolean tracerRuleOutputEnabled;
    @Value(value="${spring.application.strategy.tracer.span.value:NEPXION}")
    protected String tracerSpanValue;
    @Value(value="${spring.application.strategy.tracer.span.tag.plugin.value:Nepxion Discovery}")
    protected String tracerSpanPluginValue;

    @Override
    public void spanBuild() {
        if (!this.tracerEnabled.booleanValue()) {
            return;
        }
        if (!this.tracerSeparateSpanEnabled.booleanValue()) {
            return;
        }
        S span = this.buildSpan();
        StrategyTracerContext.getCurrentContext().setSpan(span);
    }

    @Override
    public void spanOutput(Map<String, String> contextMap) {
        Map<String, String> customizationMap;
        if (!this.tracerEnabled.booleanValue()) {
            return;
        }
        S span = this.getCurrentSpan();
        if (span == null) {
            return;
        }
        if (MapUtils.isNotEmpty(contextMap)) {
            for (Map.Entry<String, String> entry : contextMap.entrySet()) {
                this.outputSpan(span, entry.getKey(), entry.getValue());
            }
        }
        if (MapUtils.isNotEmpty(customizationMap = this.strategyMonitorContext.getCustomizationMap())) {
            for (Map.Entry<String, String> entry : customizationMap.entrySet()) {
                this.outputSpan(span, entry.getKey(), entry.getValue());
            }
        }
        if (this.tracerSeparateSpanEnabled.booleanValue()) {
            this.outputSpan(span, "plugin", this.tracerSpanPluginValue);
        }
        this.outputSpan(span, "trace-id", this.toTraceId(span));
        this.outputSpan(span, "span-id", this.toSpanId(span));
        this.outputSpan(span, "n-d-service-group", this.pluginAdapter.getGroup());
        this.outputSpan(span, "n-d-service-type", this.pluginAdapter.getServiceType());
        String string = this.pluginAdapter.getServiceAppId();
        if (StringUtils.isNotEmpty((CharSequence)string)) {
            this.outputSpan(span, "n-d-service-app-id", string);
        }
        this.outputSpan(span, "n-d-service-id", this.pluginAdapter.getServiceId());
        this.outputSpan(span, "n-d-service-address", this.pluginAdapter.getHost() + ":" + this.pluginAdapter.getPort());
        this.outputSpan(span, "n-d-service-version", this.pluginAdapter.getVersion());
        this.outputSpan(span, "n-d-service-region", this.pluginAdapter.getRegion());
        this.outputSpan(span, "n-d-service-env", this.pluginAdapter.getEnvironment());
        this.outputSpan(span, "n-d-service-zone", this.pluginAdapter.getZone());
        if (this.tracerRuleOutputEnabled.booleanValue()) {
            String addressBlacklist;
            String idBlacklist;
            String routeRegionWeight;
            String routeVersionWeight;
            String routeAddress;
            String routeEnvironment;
            String routeRegion;
            String string2 = this.strategyContextHolder.getHeader("n-d-version");
            if (StringUtils.isNotEmpty((CharSequence)string2)) {
                this.outputSpan(span, "n-d-version", string2);
            }
            if (StringUtils.isNotEmpty((CharSequence)(routeRegion = this.strategyContextHolder.getHeader("n-d-region")))) {
                this.outputSpan(span, "n-d-region", routeRegion);
            }
            if (StringUtils.isNotEmpty((CharSequence)(routeEnvironment = this.strategyContextHolder.getHeader("n-d-env")))) {
                this.outputSpan(span, "n-d-env", routeEnvironment);
            }
            if (StringUtils.isNotEmpty((CharSequence)(routeAddress = this.strategyContextHolder.getHeader("n-d-address")))) {
                this.outputSpan(span, "n-d-address", routeAddress);
            }
            if (StringUtils.isNotEmpty((CharSequence)(routeVersionWeight = this.strategyContextHolder.getHeader("n-d-version-weight")))) {
                this.outputSpan(span, "n-d-version-weight", routeVersionWeight);
            }
            if (StringUtils.isNotEmpty((CharSequence)(routeRegionWeight = this.strategyContextHolder.getHeader("n-d-region-weight")))) {
                this.outputSpan(span, "n-d-region-weight", routeRegionWeight);
            }
            if (StringUtils.isNotEmpty((CharSequence)(idBlacklist = this.strategyContextHolder.getHeader("n-d-id-blacklist")))) {
                this.outputSpan(span, "n-d-id-blacklist", idBlacklist);
            }
            if (StringUtils.isNotEmpty((CharSequence)(addressBlacklist = this.strategyContextHolder.getHeader("n-d-address-blacklist")))) {
                this.outputSpan(span, "n-d-address-blacklist", addressBlacklist);
            }
        }
    }

    @Override
    public void spanError(Throwable e) {
        if (!this.tracerEnabled.booleanValue()) {
            return;
        }
        if (!this.tracerSeparateSpanEnabled.booleanValue()) {
            return;
        }
        S span = this.getCurrentSpan();
        if (span == null) {
            return;
        }
        this.errorSpan(span, e);
    }

    @Override
    public void spanFinish() {
        if (!this.tracerEnabled.booleanValue()) {
            return;
        }
        if (!this.tracerSeparateSpanEnabled.booleanValue()) {
            return;
        }
        S span = this.getCurrentSpan();
        if (span != null) {
            this.finishSpan(span);
        }
        StrategyTracerContext.clearCurrentContext();
    }

    private S getCurrentSpan() {
        return (S)(this.tracerSeparateSpanEnabled != false ? StrategyTracerContext.getCurrentContext().getSpan() : this.getActiveSpan());
    }

    @Override
    public String getTraceId() {
        if (!this.tracerEnabled.booleanValue()) {
            return null;
        }
        S span = this.getCurrentSpan();
        if (span != null) {
            return this.toTraceId(span);
        }
        return null;
    }

    @Override
    public String getSpanId() {
        if (!this.tracerEnabled.booleanValue()) {
            return null;
        }
        S span = this.getCurrentSpan();
        if (span != null) {
            return this.toSpanId(span);
        }
        return null;
    }

    protected abstract S buildSpan();

    protected abstract void outputSpan(S var1, String var2, String var3);

    protected abstract void errorSpan(S var1, Throwable var2);

    protected abstract void finishSpan(S var1);

    protected abstract S getActiveSpan();

    protected abstract String toTraceId(S var1);

    protected abstract String toSpanId(S var1);
}

