/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.filter;

import com.nepxion.discovery.common.entity.ServiceType;
import com.nepxion.discovery.common.util.JsonUtil;
import com.nepxion.discovery.common.util.StringUtil;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.context.PluginContextHolder;
import com.nepxion.discovery.plugin.strategy.adapter.StrategyVersionFilterAdapter;
import com.nepxion.discovery.plugin.strategy.matcher.DiscoveryMatcherStrategy;
import com.netflix.loadbalancer.Server;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class StrategyVersionFilter {
    @Autowired
    private DiscoveryMatcherStrategy discoveryMatcherStrategy;
    @Autowired
    protected PluginAdapter pluginAdapter;
    @Autowired
    protected PluginContextHolder pluginContextHolder;
    @Autowired
    protected StrategyVersionFilterAdapter strategyVersionFilterAdapter;
    @Autowired
    protected DiscoveryClient discoveryClient;
    @Value(value="${spring.application.strategy.consumer.isolation.enabled:false}")
    protected Boolean consumerIsolationEnabled;
    @Value(value="${spring.application.strategy.environment.route:common}")
    protected String environmentRoute;
    @Value(value="${spring.application.strategy.zone.affinity.enabled:false}")
    protected Boolean zoneAffinityEnabled;
    @Value(value="${spring.application.strategy.zone.route.enabled:true}")
    protected Boolean zoneRouteEnabled;

    public boolean apply(Server server) {
        String version = this.pluginAdapter.getServerVersion(server);
        if (StringUtils.equals((CharSequence)version, (CharSequence)"default")) {
            return true;
        }
        List<String> versionList = this.getVersionList(server);
        if (versionList.size() <= 1) {
            return true;
        }
        List<String> filterVersionList = this.strategyVersionFilterAdapter.filter(versionList);
        return filterVersionList.contains(version);
    }

    private List<String> getVersionList(Server server) {
        String serviceId = this.pluginAdapter.getServerServiceId(server);
        List instances = this.discoveryClient.getInstances(serviceId);
        ArrayList<String> versionList = new ArrayList<String>();
        for (ServiceInstance instance : instances) {
            String version = this.pluginAdapter.getInstanceVersion(instance);
            if (versionList.contains(version) || StringUtils.equals((CharSequence)version, (CharSequence)"default") || !this.applyGroup(instance) || !this.applyEnvironment(instance) || !this.applyZone(instance) || !this.applyRegion(instance) || !this.applyAddress(instance) || !this.applyIdBlacklist(instance) || !this.applyAddressBlacklist(instance)) continue;
            versionList.add(version);
        }
        if (versionList.size() > 1) {
            Collections.sort(versionList);
        }
        return versionList;
    }

    public boolean applyGroup(ServiceInstance instance) {
        if (!this.consumerIsolationEnabled.booleanValue()) {
            return true;
        }
        String instanceServiceType = this.pluginAdapter.getInstanceServiceType(instance);
        if (StringUtils.equals((CharSequence)instanceServiceType, (CharSequence)ServiceType.GATEWAY.toString())) {
            return true;
        }
        String instanceGroup = this.pluginAdapter.getInstanceGroup(instance);
        String group = this.pluginAdapter.getGroup();
        return StringUtils.equals((CharSequence)instanceGroup, (CharSequence)group);
    }

    public boolean applyEnvironment(ServiceInstance instance) {
        String environmentValue = this.pluginContextHolder.getContextRouteEnvironment();
        if (StringUtils.isEmpty((CharSequence)environmentValue)) {
            return true;
        }
        String serviceId = this.pluginAdapter.getInstanceServiceId(instance);
        List instances = this.discoveryClient.getInstances(serviceId);
        boolean matched = false;
        for (ServiceInstance serviceInstance : instances) {
            String instanceEnvironment = this.pluginAdapter.getInstanceEnvironment(serviceInstance);
            if (!StringUtils.equals((CharSequence)environmentValue, (CharSequence)instanceEnvironment)) continue;
            matched = true;
            break;
        }
        String environment = this.pluginAdapter.getInstanceEnvironment(instance);
        if (matched) {
            return StringUtils.equals((CharSequence)environment, (CharSequence)environmentValue);
        }
        return StringUtils.equals((CharSequence)environment, (CharSequence)this.environmentRoute) || StringUtils.equals((CharSequence)environment, (CharSequence)"default");
    }

    public boolean applyZone(ServiceInstance instance) {
        if (!this.zoneAffinityEnabled.booleanValue()) {
            return true;
        }
        String zone = this.pluginAdapter.getZone();
        if (StringUtils.equals((CharSequence)zone, (CharSequence)"default")) {
            return true;
        }
        String serviceId = this.pluginAdapter.getInstanceServiceId(instance);
        List instances = this.discoveryClient.getInstances(serviceId);
        boolean matched = false;
        for (ServiceInstance serviceInstance : instances) {
            String instanceZone = this.pluginAdapter.getInstanceZone(serviceInstance);
            if (!StringUtils.equals((CharSequence)zone, (CharSequence)instanceZone)) continue;
            matched = true;
            break;
        }
        String instanceZone = this.pluginAdapter.getInstanceZone(instance);
        if (matched) {
            return StringUtils.equals((CharSequence)instanceZone, (CharSequence)zone);
        }
        if (this.zoneRouteEnabled.booleanValue()) {
            return true;
        }
        return StringUtils.equals((CharSequence)instanceZone, (CharSequence)zone);
    }

    public boolean applyRegion(ServiceInstance instance) {
        String serviceId = this.pluginAdapter.getInstanceServiceId(instance);
        String regions = this.getRegions(serviceId);
        if (StringUtils.isEmpty((CharSequence)regions)) {
            return true;
        }
        String region = this.pluginAdapter.getInstanceRegion(instance);
        List regionList = StringUtil.splitToList((String)regions);
        if (regionList.contains(region)) {
            return true;
        }
        for (String regionPattern : regionList) {
            if (!this.discoveryMatcherStrategy.match(regionPattern, region)) continue;
            return true;
        }
        return false;
    }

    public String getRegions(String serviceId) {
        String regionValue = this.pluginContextHolder.getContextRouteRegion();
        if (StringUtils.isEmpty((CharSequence)regionValue)) {
            return null;
        }
        String regions = null;
        try {
            Map regionMap = (Map)JsonUtil.fromJson((String)regionValue, Map.class);
            regions = (String)regionMap.get(serviceId);
        }
        catch (Exception e) {
            regions = regionValue;
        }
        return regions;
    }

    public boolean applyAddress(ServiceInstance instance) {
        String serviceId = this.pluginAdapter.getInstanceServiceId(instance);
        String addresses = this.getAddresses(serviceId);
        if (StringUtils.isEmpty((CharSequence)addresses)) {
            return true;
        }
        List addressList = StringUtil.splitToList((String)addresses);
        if (addressList.contains(instance.getHost() + ":" + instance.getPort()) || addressList.contains(instance.getHost()) || addressList.contains(String.valueOf(instance.getPort()))) {
            return true;
        }
        for (String addressPattern : addressList) {
            if (!this.discoveryMatcherStrategy.match(addressPattern, instance.getHost() + ":" + instance.getPort()) && !this.discoveryMatcherStrategy.match(addressPattern, instance.getHost()) && !this.discoveryMatcherStrategy.match(addressPattern, String.valueOf(instance.getPort()))) continue;
            return true;
        }
        return false;
    }

    public String getAddresses(String serviceId) {
        String addressValue = this.pluginContextHolder.getContextRouteAddress();
        if (StringUtils.isEmpty((CharSequence)addressValue)) {
            return null;
        }
        String addresses = null;
        try {
            Map addressMap = (Map)JsonUtil.fromJson((String)addressValue, Map.class);
            addresses = (String)addressMap.get(serviceId);
        }
        catch (Exception e) {
            addresses = addressValue;
        }
        return addresses;
    }

    public boolean applyIdBlacklist(ServiceInstance instance) {
        String ids = this.pluginContextHolder.getContextRouteIdBlacklist();
        if (StringUtils.isEmpty((CharSequence)ids)) {
            return true;
        }
        String serviceUUId = this.pluginAdapter.getInstanceServiceUUId(instance);
        List idList = StringUtil.splitToList((String)ids);
        return !idList.contains(serviceUUId);
    }

    public boolean applyAddressBlacklist(ServiceInstance instance) {
        String addresses = this.pluginContextHolder.getContextRouteAddressBlacklist();
        if (StringUtils.isEmpty((CharSequence)addresses)) {
            return true;
        }
        List addressList = StringUtil.splitToList((String)addresses);
        if (addressList.contains(instance.getHost() + ":" + instance.getPort()) || addressList.contains(instance.getHost()) || addressList.contains(String.valueOf(instance.getPort()))) {
            return false;
        }
        for (String addressPattern : addressList) {
            if (!this.discoveryMatcherStrategy.match(addressPattern, instance.getHost() + ":" + instance.getPort()) && !this.discoveryMatcherStrategy.match(addressPattern, instance.getHost()) && !this.discoveryMatcherStrategy.match(addressPattern, String.valueOf(instance.getPort()))) continue;
            return false;
        }
        return true;
    }

    public boolean applyVersion(ServiceInstance instance) {
        String serviceId = this.pluginAdapter.getInstanceServiceId(instance);
        String versions = this.getVersions(serviceId);
        if (StringUtils.isEmpty((CharSequence)versions)) {
            return true;
        }
        String version = this.pluginAdapter.getInstanceVersion(instance);
        List versionList = StringUtil.splitToList((String)versions);
        if (versionList.contains(version)) {
            return true;
        }
        for (String versionPattern : versionList) {
            if (!this.discoveryMatcherStrategy.match(versionPattern, version)) continue;
            return true;
        }
        return false;
    }

    public String getVersions(String serviceId) {
        String versionValue = this.pluginContextHolder.getContextRouteVersion();
        if (StringUtils.isEmpty((CharSequence)versionValue)) {
            return null;
        }
        String versions = null;
        try {
            Map versionMap = (Map)JsonUtil.fromJson((String)versionValue, Map.class);
            versions = (String)versionMap.get(serviceId);
        }
        catch (Exception e) {
            versions = versionValue;
        }
        return versions;
    }
}

