/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.condition;

import com.nepxion.discovery.common.entity.StrategyConditionEntity;
import com.nepxion.discovery.common.expression.DiscoveryExpressionResolver;
import com.nepxion.discovery.plugin.strategy.condition.AbstractStrategyCondition;
import com.nepxion.discovery.plugin.strategy.wrapper.StrategyWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.TypeComparator;

public class ExpressionStrategyCondition
extends AbstractStrategyCondition {
    private Pattern pattern = Pattern.compile("\\#H\\['\\S+'\\]");
    @Autowired
    private StrategyWrapper strategyWrapper;

    @Override
    public boolean isTriggered(StrategyConditionEntity strategyConditionEntity) {
        Map<String, String> map = this.createMap(strategyConditionEntity);
        return this.isTriggered(strategyConditionEntity, map);
    }

    private Map<String, String> createMap(StrategyConditionEntity strategyConditionEntity) {
        String expression = strategyConditionEntity.getExpression();
        if (StringUtils.isEmpty((CharSequence)expression)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Matcher matcher = this.pattern.matcher(expression);
        while (matcher.find()) {
            String group = matcher.group();
            String name = StringUtils.substringBetween((String)group, (String)"#H['", (String)"']");
            String value = null;
            if (StringUtils.isBlank(value)) {
                value = this.strategyContextHolder.getParameter(name);
            }
            if (StringUtils.isBlank(value)) {
                value = this.strategyContextHolder.getCookie(name);
            }
            if (StringUtils.isBlank((CharSequence)value)) {
                value = this.strategyContextHolder.getHeader(name);
            }
            if (StringUtils.isBlank((CharSequence)value)) {
                value = this.strategyWrapper.getHeader(name);
            }
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            map.put(name, value);
        }
        return map;
    }

    @Override
    public boolean isTriggered(StrategyConditionEntity strategyConditionEntity, Map<String, String> map) {
        String expression = strategyConditionEntity.getExpression();
        return DiscoveryExpressionResolver.eval((String)expression, (String)"H", map, (TypeComparator)this.strategyTypeComparator);
    }
}

