/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.aop;

import com.nepxion.discovery.common.entity.InterceptorType;
import com.nepxion.discovery.plugin.strategy.aop.AbstractStrategyInterceptor;
import com.nepxion.discovery.plugin.strategy.context.StrategyContextHolder;
import com.nepxion.discovery.plugin.strategy.util.StrategyUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class RestTemplateStrategyInterceptor
extends AbstractStrategyInterceptor
implements ClientHttpRequestInterceptor {
    @Autowired
    protected StrategyContextHolder strategyContextHolder;
    @Value(value="${spring.application.strategy.rest.template.core.header.transmission.enabled:true}")
    protected Boolean restTemplateCoreHeaderTransmissionEnabled;

    public RestTemplateStrategyInterceptor(String contextRequestHeaders, String businessRequestHeaders) {
        super(contextRequestHeaders, businessRequestHeaders);
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.interceptInputHeader();
        this.applyInnerHeader(request);
        this.applyOuterHeader(request);
        this.interceptOutputHeader(request);
        return execution.execute(request, body);
    }

    private void applyInnerHeader(HttpRequest request) {
        HttpHeaders headers = request.getHeaders();
        headers.add("n-d-service-group", this.pluginAdapter.getGroup());
        headers.add("n-d-service-type", this.pluginAdapter.getServiceType());
        String serviceAppId = this.pluginAdapter.getServiceAppId();
        if (StringUtils.isNotEmpty((CharSequence)serviceAppId)) {
            headers.add("n-d-service-app-id", serviceAppId);
        }
        headers.add("n-d-service-id", this.pluginAdapter.getServiceId());
        headers.add("n-d-service-address", this.pluginAdapter.getHost() + ":" + this.pluginAdapter.getPort());
        headers.add("n-d-service-version", this.pluginAdapter.getVersion());
        headers.add("n-d-service-region", this.pluginAdapter.getRegion());
        headers.add("n-d-service-env", this.pluginAdapter.getEnvironment());
        headers.add("n-d-service-zone", this.pluginAdapter.getZone());
    }

    private void applyOuterHeader(HttpRequest request) {
        HttpHeaders headers;
        Enumeration<String> headerNames = this.strategyContextHolder.getHeaderNames();
        if (headerNames != null) {
            headers = request.getHeaders();
            while (headerNames.hasMoreElements()) {
                String headerName = headerNames.nextElement();
                String headerValue = this.strategyContextHolder.getHeader(headerName);
                boolean isHeaderContains = this.isHeaderContainsExcludeInner(headerName.toLowerCase());
                if (!isHeaderContains) continue;
                if (this.restTemplateCoreHeaderTransmissionEnabled.booleanValue()) {
                    headers.add(headerName, headerValue);
                    continue;
                }
                boolean isCoreHeaderContains = StrategyUtil.isCoreHeaderContains(headerName);
                if (isCoreHeaderContains) continue;
                headers.add(headerName, headerValue);
            }
        }
        if (this.restTemplateCoreHeaderTransmissionEnabled.booleanValue()) {
            String routeAddressBlacklist;
            String routeIdBlacklist;
            String routeRegionWeight;
            String routeVersionWeight;
            String routeAddress;
            String routeEnvironment;
            String routeRegion;
            String routeVersion;
            headers = request.getHeaders();
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-version")) && StringUtils.isNotEmpty((CharSequence)(routeVersion = this.strategyContextHolder.getRouteVersion()))) {
                headers.add("n-d-version", routeVersion);
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-region")) && StringUtils.isNotEmpty((CharSequence)(routeRegion = this.strategyContextHolder.getRouteRegion()))) {
                headers.add("n-d-region", routeRegion);
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-env")) && StringUtils.isNotEmpty((CharSequence)(routeEnvironment = this.strategyContextHolder.getRouteEnvironment()))) {
                headers.add("n-d-env", routeEnvironment);
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-address")) && StringUtils.isNotEmpty((CharSequence)(routeAddress = this.strategyContextHolder.getRouteAddress()))) {
                headers.add("n-d-address", routeAddress);
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-version-weight")) && StringUtils.isNotEmpty((CharSequence)(routeVersionWeight = this.strategyContextHolder.getRouteVersionWeight()))) {
                headers.add("n-d-version-weight", routeVersionWeight);
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-region-weight")) && StringUtils.isNotEmpty((CharSequence)(routeRegionWeight = this.strategyContextHolder.getRouteRegionWeight()))) {
                headers.add("n-d-region-weight", routeRegionWeight);
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-id-blacklist")) && StringUtils.isNotEmpty((CharSequence)(routeIdBlacklist = this.strategyContextHolder.getRouteIdBlacklist()))) {
                headers.add("n-d-id-blacklist", routeIdBlacklist);
            }
            if (CollectionUtils.isEmpty((Collection)headers.get((Object)"n-d-address-blacklist")) && StringUtils.isNotEmpty((CharSequence)(routeAddressBlacklist = this.strategyContextHolder.getRouteAddressBlacklist()))) {
                headers.add("n-d-address-blacklist", routeAddressBlacklist);
            }
        }
    }

    private void interceptOutputHeader(HttpRequest request) {
        if (!this.interceptDebugEnabled.booleanValue()) {
            return;
        }
        System.out.println("----- RestTemplate Intercept Output Header Information -----");
        HttpHeaders headers = request.getHeaders();
        for (Map.Entry header : headers.entrySet()) {
            String headerName = (String)header.getKey();
            boolean isHeaderContains = this.isHeaderContains(headerName.toLowerCase());
            if (!isHeaderContains) continue;
            List headerValue = (List)header.getValue();
            System.out.println(headerName + "=" + headerValue);
        }
        System.out.println("------------------------------------------------------------");
    }

    @Override
    protected InterceptorType getInterceptorType() {
        return InterceptorType.REST_TEMPLATE;
    }
}

