/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.aop;

import com.nepxion.discovery.common.entity.InterceptorType;
import com.nepxion.discovery.plugin.strategy.aop.AbstractStrategyInterceptor;
import com.nepxion.discovery.plugin.strategy.context.StrategyContextHolder;
import com.nepxion.discovery.plugin.strategy.util.StrategyUtil;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class FeignStrategyInterceptor
extends AbstractStrategyInterceptor
implements RequestInterceptor {
    @Autowired
    protected StrategyContextHolder strategyContextHolder;
    @Value(value="${spring.application.strategy.feign.core.header.transmission.enabled:true}")
    protected Boolean feignCoreHeaderTransmissionEnabled;

    public FeignStrategyInterceptor(String contextRequestHeaders, String businessRequestHeaders) {
        super(contextRequestHeaders, businessRequestHeaders);
    }

    public void apply(RequestTemplate requestTemplate) {
        this.interceptInputHeader();
        this.applyInnerHeader(requestTemplate);
        this.applyOuterHeader(requestTemplate);
        this.interceptOutputHeader(requestTemplate);
    }

    private void applyInnerHeader(RequestTemplate requestTemplate) {
        requestTemplate.header("n-d-service-group", new String[]{this.pluginAdapter.getGroup()});
        requestTemplate.header("n-d-service-type", new String[]{this.pluginAdapter.getServiceType()});
        String serviceAppId = this.pluginAdapter.getServiceAppId();
        if (StringUtils.isNotEmpty((CharSequence)serviceAppId)) {
            requestTemplate.header("n-d-service-app-id", new String[]{serviceAppId});
        }
        requestTemplate.header("n-d-service-id", new String[]{this.pluginAdapter.getServiceId()});
        requestTemplate.header("n-d-service-address", new String[]{this.pluginAdapter.getHost() + ":" + this.pluginAdapter.getPort()});
        requestTemplate.header("n-d-service-version", new String[]{this.pluginAdapter.getVersion()});
        requestTemplate.header("n-d-service-region", new String[]{this.pluginAdapter.getRegion()});
        requestTemplate.header("n-d-service-env", new String[]{this.pluginAdapter.getEnvironment()});
        requestTemplate.header("n-d-service-zone", new String[]{this.pluginAdapter.getZone()});
    }

    private void applyOuterHeader(RequestTemplate requestTemplate) {
        Enumeration<String> headerNames = this.strategyContextHolder.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = headerNames.nextElement();
                String headerValue = this.strategyContextHolder.getHeader(headerName);
                boolean isHeaderContains = this.isHeaderContainsExcludeInner(headerName.toLowerCase());
                if (!isHeaderContains) continue;
                if (this.feignCoreHeaderTransmissionEnabled.booleanValue()) {
                    requestTemplate.header(headerName, new String[]{headerValue});
                    continue;
                }
                boolean isCoreHeaderContains = StrategyUtil.isCoreHeaderContains(headerName);
                if (isCoreHeaderContains) continue;
                requestTemplate.header(headerName, new String[]{headerValue});
            }
        }
        if (this.feignCoreHeaderTransmissionEnabled.booleanValue()) {
            String routeAddressBlacklist;
            String routeIdBlacklist;
            String routeRegionWeight;
            String routeVersionWeight;
            String routeAddress;
            String routeEnvironment;
            String routeRegion;
            String routeVersion;
            Map headers = requestTemplate.headers();
            if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-version"))) && StringUtils.isNotEmpty((CharSequence)(routeVersion = this.strategyContextHolder.getRouteVersion()))) {
                requestTemplate.header("n-d-version", new String[]{routeVersion});
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-region"))) && StringUtils.isNotEmpty((CharSequence)(routeRegion = this.strategyContextHolder.getRouteRegion()))) {
                requestTemplate.header("n-d-region", new String[]{routeRegion});
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-env"))) && StringUtils.isNotEmpty((CharSequence)(routeEnvironment = this.strategyContextHolder.getRouteEnvironment()))) {
                requestTemplate.header("n-d-env", new String[]{routeEnvironment});
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-address"))) && StringUtils.isNotEmpty((CharSequence)(routeAddress = this.strategyContextHolder.getRouteAddress()))) {
                requestTemplate.header("n-d-address", new String[]{routeAddress});
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-version-weight"))) && StringUtils.isNotEmpty((CharSequence)(routeVersionWeight = this.strategyContextHolder.getRouteVersionWeight()))) {
                requestTemplate.header("n-d-version-weight", new String[]{routeVersionWeight});
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-region-weight"))) && StringUtils.isNotEmpty((CharSequence)(routeRegionWeight = this.strategyContextHolder.getRouteRegionWeight()))) {
                requestTemplate.header("n-d-region-weight", new String[]{routeRegionWeight});
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-id-blacklist"))) && StringUtils.isNotEmpty((CharSequence)(routeIdBlacklist = this.strategyContextHolder.getRouteIdBlacklist()))) {
                requestTemplate.header("n-d-id-blacklist", new String[]{routeIdBlacklist});
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("n-d-address-blacklist"))) && StringUtils.isNotEmpty((CharSequence)(routeAddressBlacklist = this.strategyContextHolder.getRouteAddressBlacklist()))) {
                requestTemplate.header("n-d-address-blacklist", new String[]{routeAddressBlacklist});
            }
        }
    }

    private void interceptOutputHeader(RequestTemplate requestTemplate) {
        if (!this.interceptDebugEnabled.booleanValue()) {
            return;
        }
        System.out.println("-------- Feign Intercept Output Header Information ---------");
        Map headers = requestTemplate.headers();
        for (Map.Entry entry : headers.entrySet()) {
            String headerName = (String)entry.getKey();
            boolean isHeaderContains = this.isHeaderContains(headerName.toLowerCase());
            if (!isHeaderContains) continue;
            Collection headerValue = (Collection)entry.getValue();
            System.out.println(headerName + "=" + headerValue);
        }
        System.out.println("------------------------------------------------------------");
    }

    @Override
    protected InterceptorType getInterceptorType() {
        return InterceptorType.FEIGN;
    }
}

