/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.aop;

import com.nepxion.discovery.common.entity.InterceptorType;
import com.nepxion.discovery.common.util.StringUtil;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.strategy.context.StrategyContextHolder;
import com.nepxion.discovery.plugin.strategy.util.StrategyUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.ConfigurableEnvironment;

public abstract class AbstractStrategyInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStrategyInterceptor.class);
    @Autowired
    protected ConfigurableEnvironment environment;
    @Autowired
    protected PluginAdapter pluginAdapter;
    @Autowired
    protected StrategyContextHolder strategyContextHolder;
    @Value(value="${spring.application.strategy.rest.intercept.debug.enabled:false}")
    protected Boolean interceptDebugEnabled;
    protected List<String> requestHeaderList = new ArrayList<String>();

    public AbstractStrategyInterceptor(String contextRequestHeaders, String businessRequestHeaders) {
        if (StringUtils.isNotEmpty((CharSequence)contextRequestHeaders)) {
            this.requestHeaderList.addAll(StringUtil.splitToList((String)contextRequestHeaders.toLowerCase()));
        }
        if (StringUtils.isNotEmpty((CharSequence)businessRequestHeaders)) {
            this.requestHeaderList.addAll(StringUtil.splitToList((String)businessRequestHeaders.toLowerCase()));
        }
        InterceptorType interceptorType = this.getInterceptorType();
        LOG.info("--------- Strategy Intercept Information ---------");
        LOG.info("{} desires to intercept customer headers are {}", (Object)interceptorType, this.requestHeaderList);
        LOG.info("--------------------------------------------------");
    }

    protected void interceptInputHeader() {
        if (!this.interceptDebugEnabled.booleanValue()) {
            return;
        }
        Enumeration<String> headerNames = this.strategyContextHolder.getHeaderNames();
        if (headerNames != null) {
            InterceptorType interceptorType = this.getInterceptorType();
            switch (interceptorType) {
                case FEIGN: {
                    System.out.println("--------- Feign Intercept Input Header Information ---------");
                    break;
                }
                case REST_TEMPLATE: {
                    System.out.println("----- RestTemplate Intercept Input Header Information ------");
                    break;
                }
                case WEB_CLIENT: {
                    System.out.println("------- WebClient Intercept Input Header Information -------");
                }
            }
            while (headerNames.hasMoreElements()) {
                String headerName = headerNames.nextElement();
                boolean isHeaderContains = this.isHeaderContains(headerName.toLowerCase());
                if (!isHeaderContains) continue;
                String headerValue = this.strategyContextHolder.getHeader(headerName);
                System.out.println(headerName + "=" + headerValue);
            }
            System.out.println("------------------------------------------------------------");
        }
    }

    protected boolean isHeaderContains(String headerName) {
        return headerName.startsWith("n-d-") || this.requestHeaderList.contains(headerName);
    }

    protected boolean isHeaderContainsExcludeInner(String headerName) {
        return this.isHeaderContains(headerName) && !StrategyUtil.isInnerHeaderContains(headerName);
    }

    protected abstract InterceptorType getInterceptorType();
}

