/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.adapter;

import com.nepxion.discovery.common.entity.ServiceType;
import com.nepxion.discovery.common.util.JsonUtil;
import com.nepxion.discovery.common.util.StringUtil;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.context.PluginContextHolder;
import com.nepxion.discovery.plugin.strategy.adapter.DiscoveryEnabledAdapter;
import com.nepxion.discovery.plugin.strategy.adapter.DiscoveryEnabledStrategy;
import com.nepxion.discovery.plugin.strategy.filter.StrategyVersionFilter;
import com.nepxion.discovery.plugin.strategy.matcher.DiscoveryMatcherStrategy;
import com.netflix.loadbalancer.Server;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.util.CollectionUtils;

public class DefaultDiscoveryEnabledAdapter
implements DiscoveryEnabledAdapter {
    @Autowired(required=false)
    protected List<DiscoveryEnabledStrategy> discoveryEnabledStrategyList;
    @Autowired
    protected DiscoveryMatcherStrategy discoveryMatcherStrategy;
    @Autowired
    protected StrategyVersionFilter strategyVersionFilter;
    @Autowired
    protected PluginAdapter pluginAdapter;
    @Autowired
    protected PluginContextHolder pluginContextHolder;
    @Autowired
    protected DiscoveryClient discoveryClient;
    @Value(value="${spring.application.strategy.consumer.isolation.enabled:false}")
    protected Boolean consumerIsolationEnabled;
    @Value(value="${spring.application.strategy.environment.route:common}")
    protected String environmentRoute;
    @Value(value="${spring.application.strategy.zone.affinity.enabled:false}")
    protected Boolean zoneAffinityEnabled;
    @Value(value="${spring.application.strategy.zone.route.enabled:true}")
    protected Boolean zoneRouteEnabled;
    @Value(value="${spring.application.strategy.version.failover.enabled:false}")
    protected Boolean versionFailoverEnabled;
    @Value(value="${spring.application.strategy.version.prefer.enabled:false}")
    protected Boolean versionPreferEnabled;

    public boolean apply(Server server) {
        boolean enabled = this.applyGroup(server);
        if (!enabled) {
            return false;
        }
        enabled = this.applyEnvironment(server);
        if (!enabled) {
            return false;
        }
        enabled = this.applyZone(server);
        if (!enabled) {
            return false;
        }
        enabled = this.applyRegion(server);
        if (!enabled) {
            return false;
        }
        enabled = this.applyAddress(server);
        if (!enabled) {
            return false;
        }
        enabled = this.applyIdBlacklist(server);
        if (!enabled) {
            return false;
        }
        enabled = this.applyAddressBlacklist(server);
        if (!enabled) {
            return false;
        }
        enabled = this.applyVersion(server);
        if (!enabled) {
            return false;
        }
        return this.applyStrategy(server);
    }

    public boolean applyGroup(Server server) {
        if (!this.consumerIsolationEnabled.booleanValue()) {
            return true;
        }
        String serverServiceType = this.pluginAdapter.getServerServiceType(server);
        if (StringUtils.equals((CharSequence)serverServiceType, (CharSequence)ServiceType.GATEWAY.toString())) {
            return true;
        }
        String serverGroup = this.pluginAdapter.getServerGroup(server);
        String group = this.pluginAdapter.getGroup();
        return StringUtils.equals((CharSequence)serverGroup, (CharSequence)group);
    }

    public boolean applyEnvironment(Server server) {
        String environmentValue = this.pluginContextHolder.getContextRouteEnvironment();
        if (StringUtils.isEmpty((CharSequence)environmentValue)) {
            return true;
        }
        String serviceId = this.pluginAdapter.getServerServiceId(server);
        List instances = this.discoveryClient.getInstances(serviceId);
        boolean matched = false;
        for (ServiceInstance instance : instances) {
            String instanceEnvironment = this.pluginAdapter.getInstanceEnvironment(instance);
            if (!StringUtils.equals((CharSequence)environmentValue, (CharSequence)instanceEnvironment)) continue;
            matched = true;
            break;
        }
        String environment = this.pluginAdapter.getServerEnvironment(server);
        if (matched) {
            return StringUtils.equals((CharSequence)environment, (CharSequence)environmentValue);
        }
        return StringUtils.equals((CharSequence)environment, (CharSequence)this.environmentRoute) || StringUtils.equals((CharSequence)environment, (CharSequence)"default");
    }

    public boolean applyZone(Server server) {
        if (!this.zoneAffinityEnabled.booleanValue()) {
            return true;
        }
        String zone = this.pluginAdapter.getZone();
        if (StringUtils.equals((CharSequence)zone, (CharSequence)"default")) {
            return true;
        }
        String serviceId = this.pluginAdapter.getServerServiceId(server);
        List instances = this.discoveryClient.getInstances(serviceId);
        boolean matched = false;
        for (ServiceInstance instance : instances) {
            String instanceZone = this.pluginAdapter.getInstanceZone(instance);
            if (!StringUtils.equals((CharSequence)zone, (CharSequence)instanceZone)) continue;
            matched = true;
            break;
        }
        String serverZone = this.pluginAdapter.getServerZone(server);
        if (matched) {
            return StringUtils.equals((CharSequence)serverZone, (CharSequence)zone);
        }
        if (this.zoneRouteEnabled.booleanValue()) {
            return true;
        }
        return StringUtils.equals((CharSequence)serverZone, (CharSequence)zone);
    }

    public boolean applyRegion(Server server) {
        String serviceId = this.pluginAdapter.getServerServiceId(server);
        String regions = this.getRegions(serviceId);
        if (StringUtils.isEmpty((CharSequence)regions)) {
            return true;
        }
        String region = this.pluginAdapter.getServerRegion(server);
        List regionList = StringUtil.splitToList((String)regions);
        if (regionList.contains(region)) {
            return true;
        }
        for (String regionPattern : regionList) {
            if (!this.discoveryMatcherStrategy.match(regionPattern, region)) continue;
            return true;
        }
        return false;
    }

    public String getRegions(String serviceId) {
        String regionValue = this.pluginContextHolder.getContextRouteRegion();
        if (StringUtils.isEmpty((CharSequence)regionValue)) {
            return null;
        }
        String regions = null;
        try {
            Map regionMap = (Map)JsonUtil.fromJson((String)regionValue, Map.class);
            regions = (String)regionMap.get(serviceId);
        }
        catch (Exception e) {
            regions = regionValue;
        }
        return regions;
    }

    public boolean applyAddress(Server server) {
        String serviceId = this.pluginAdapter.getServerServiceId(server);
        String addresses = this.getAddresses(serviceId);
        if (StringUtils.isEmpty((CharSequence)addresses)) {
            return true;
        }
        List addressList = StringUtil.splitToList((String)addresses);
        if (addressList.contains(server.getHost() + ":" + server.getPort()) || addressList.contains(server.getHost()) || addressList.contains(String.valueOf(server.getPort()))) {
            return true;
        }
        for (String addressPattern : addressList) {
            if (!this.discoveryMatcherStrategy.match(addressPattern, server.getHost() + ":" + server.getPort()) && !this.discoveryMatcherStrategy.match(addressPattern, server.getHost()) && !this.discoveryMatcherStrategy.match(addressPattern, String.valueOf(server.getPort()))) continue;
            return true;
        }
        return false;
    }

    public String getAddresses(String serviceId) {
        String addressValue = this.pluginContextHolder.getContextRouteAddress();
        if (StringUtils.isEmpty((CharSequence)addressValue)) {
            return null;
        }
        String addresses = null;
        try {
            Map addressMap = (Map)JsonUtil.fromJson((String)addressValue, Map.class);
            addresses = (String)addressMap.get(serviceId);
        }
        catch (Exception e) {
            addresses = addressValue;
        }
        return addresses;
    }

    public boolean applyIdBlacklist(Server server) {
        String serviceId = this.pluginAdapter.getServerServiceId(server);
        String ids = this.getIdBlacklists(serviceId);
        if (StringUtils.isEmpty((CharSequence)ids)) {
            return true;
        }
        String id = this.pluginAdapter.getServerServiceUUId(server);
        List idList = StringUtil.splitToList((String)ids);
        if (idList.contains(id)) {
            return false;
        }
        for (String idPattern : idList) {
            if (!this.discoveryMatcherStrategy.match(idPattern, id)) continue;
            return false;
        }
        return true;
    }

    public String getIdBlacklists(String serviceId) {
        String idValue = this.pluginContextHolder.getContextRouteIdBlacklist();
        if (StringUtils.isEmpty((CharSequence)idValue)) {
            return null;
        }
        String ids = null;
        try {
            Map idMap = (Map)JsonUtil.fromJson((String)idValue, Map.class);
            ids = (String)idMap.get(serviceId);
        }
        catch (Exception e) {
            ids = idValue;
        }
        return ids;
    }

    public boolean applyAddressBlacklist(Server server) {
        String serviceId = this.pluginAdapter.getServerServiceId(server);
        String addresses = this.getAddressBlacklists(serviceId);
        if (StringUtils.isEmpty((CharSequence)addresses)) {
            return true;
        }
        List addressList = StringUtil.splitToList((String)addresses);
        if (addressList.contains(server.getHost() + ":" + server.getPort()) || addressList.contains(server.getHost()) || addressList.contains(String.valueOf(server.getPort()))) {
            return false;
        }
        for (String addressPattern : addressList) {
            if (!this.discoveryMatcherStrategy.match(addressPattern, server.getHost() + ":" + server.getPort()) && !this.discoveryMatcherStrategy.match(addressPattern, server.getHost()) && !this.discoveryMatcherStrategy.match(addressPattern, String.valueOf(server.getPort()))) continue;
            return false;
        }
        return true;
    }

    public String getAddressBlacklists(String serviceId) {
        String addressValue = this.pluginContextHolder.getContextRouteAddressBlacklist();
        if (StringUtils.isEmpty((CharSequence)addressValue)) {
            return null;
        }
        String addresses = null;
        try {
            Map addressMap = (Map)JsonUtil.fromJson((String)addressValue, Map.class);
            addresses = (String)addressMap.get(serviceId);
        }
        catch (Exception e) {
            addresses = addressValue;
        }
        return addresses;
    }

    public boolean applyVersion(Server server) {
        String serviceId = this.pluginAdapter.getServerServiceId(server);
        String versions = this.getVersions(serviceId);
        if (StringUtils.isEmpty((CharSequence)versions)) {
            if (this.versionPreferEnabled.booleanValue()) {
                return this.strategyVersionFilter.apply(server);
            }
            return true;
        }
        if (this.versionFailoverEnabled.booleanValue()) {
            List instances = this.discoveryClient.getInstances(serviceId);
            boolean matched = false;
            for (ServiceInstance instance : instances) {
                if (!this.strategyVersionFilter.applyVersion(instance)) continue;
                matched = true;
                break;
            }
            if (!matched) {
                return this.strategyVersionFilter.apply(server);
            }
        }
        String version = this.pluginAdapter.getServerVersion(server);
        List versionList = StringUtil.splitToList((String)versions);
        if (versionList.contains(version)) {
            return true;
        }
        for (String versionPattern : versionList) {
            if (!this.discoveryMatcherStrategy.match(versionPattern, version)) continue;
            return true;
        }
        return false;
    }

    public String getVersions(String serviceId) {
        String versionValue = this.pluginContextHolder.getContextRouteVersion();
        if (StringUtils.isEmpty((CharSequence)versionValue)) {
            return null;
        }
        String versions = null;
        try {
            Map versionMap = (Map)JsonUtil.fromJson((String)versionValue, Map.class);
            versions = (String)versionMap.get(serviceId);
        }
        catch (Exception e) {
            versions = versionValue;
        }
        return versions;
    }

    public boolean applyStrategy(Server server) {
        if (CollectionUtils.isEmpty(this.discoveryEnabledStrategyList)) {
            return true;
        }
        for (DiscoveryEnabledStrategy discoveryEnabledStrategy : this.discoveryEnabledStrategyList) {
            boolean enabled = discoveryEnabledStrategy.apply(server);
            if (enabled) continue;
            return false;
        }
        return true;
    }

    public PluginAdapter getPluginAdapter() {
        return this.pluginAdapter;
    }

    public PluginContextHolder getPluginContextHolder() {
        return this.pluginContextHolder;
    }
}

