/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa.impl;

import com.mysema.query.jpa.EclipseLinkTemplates;
import com.mysema.query.jpa.HQLTemplates;
import com.mysema.query.jpa.JPQLTemplates;
import com.mysema.query.jpa.OpenJPATemplates;
import javax.persistence.EntityManager;

public enum JPAProvider {
    HIBERNATE("org.hibernate.Session", HQLTemplates.DEFAULT),
    ECLIPSELINK("org.eclipse.persistence.jpa.JpaEntityManager", EclipseLinkTemplates.DEFAULT),
    OPEN_JPA("org.apache.openjpa.persistence.OpenJPAEntityManager", OpenJPATemplates.DEFAULT),
    GENERIC("javax.persistence.EntityManager", JPQLTemplates.DEFAULT);

    private Class<?> delegateClass;
    private final JPQLTemplates templates;

    private JPAProvider(String emClassName, JPQLTemplates templates) {
        this.templates = templates;
        try {
            this.delegateClass = Class.forName(emClassName);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
    }

    public JPQLTemplates getTemplates() {
        return this.templates;
    }

    public static JPAProvider get(EntityManager em) {
        for (JPAProvider provider : JPAProvider.values()) {
            if (provider.delegateClass == null || !provider.delegateClass.isAssignableFrom(em.getDelegate().getClass())) continue;
            return provider;
        }
        throw new IllegalStateException("No Provider for " + em.getClass().getName());
    }

    public static JPQLTemplates getTemplates(EntityManager em) {
        return JPAProvider.get(em).getTemplates();
    }
}

