/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.util.regexp;

import com.mockrunner.util.regexp.Jsr51PatternMatcher;
import com.mockrunner.util.regexp.PatternMatcher;

public class StartsEndsPatternMatcher
extends PatternMatcher.Base {
    private final String start;
    private final String end;
    private final int minLength;

    public StartsEndsPatternMatcher(String pattern, String start, String end) {
        super(pattern);
        this.start = start;
        this.end = end;
        this.minLength = (start == null ? 0 : start.length()) + (end == null ? 0 : end.length());
    }

    @Override
    public String type() {
        return "JSR-51";
    }

    @Override
    public boolean matches(String string) {
        if (string.length() < this.minLength) {
            return false;
        }
        if (this.start != null && !string.startsWith(this.start)) {
            return false;
        }
        return this.end == null || string.endsWith(this.end);
    }

    public static class Factory
    implements PatternMatcher.Factory {
        @Override
        public PatternMatcher create(String pattern) {
            int dotStar;
            String p = pattern;
            if (p.startsWith("^")) {
                p = p.substring(1);
            }
            if (p.endsWith("$")) {
                p = p.substring(0, p.length() - 1);
            }
            if ((dotStar = p.indexOf(".*")) < 0) {
                String unescaped = this.unescape(p);
                if (unescaped == null) {
                    return new Jsr51PatternMatcher(pattern, true);
                }
                return new StartsEndsPatternMatcher(pattern, unescaped, null);
            }
            int secondDotStar = p.indexOf(".*", dotStar + 2);
            if (secondDotStar < 0) {
                String unescapedStart = this.unescape(p.substring(0, dotStar));
                String unescapedEnd = this.unescape(p.substring(dotStar + 2));
                if (unescapedStart != null && unescapedEnd != null) {
                    return new StartsEndsPatternMatcher(pattern, unescapedStart.length() == 0 ? null : unescapedStart, unescapedEnd.length() == 0 ? null : unescapedEnd);
                }
            }
            return new Jsr51PatternMatcher(pattern, true);
        }

        private String unescape(String pattern) {
            StringBuilder sb = new StringBuilder(pattern.length());
            boolean escaped = false;
            for (char c : pattern.toCharArray()) {
                if (this.isSpecial(c)) {
                    if (escaped) {
                        sb.append(c);
                        escaped = false;
                        continue;
                    }
                    if (c == '\\') {
                        escaped = true;
                        continue;
                    }
                    return null;
                }
                if (escaped) {
                    return null;
                }
                sb.append(c);
                escaped = false;
            }
            return sb.toString();
        }

        private boolean isSpecial(char c) {
            switch (c) {
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': {
                    return true;
                }
            }
            return false;
        }
    }
}

