/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.util.common;

import com.mockrunner.base.NestedApplicationException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class StringUtil {
    public static boolean isEmptyOrNull(String string) {
        return null == string || 0 >= string.length();
    }

    public static String emptyStringToNull(String string) {
        return StringUtil.isEmptyOrNull(string) ? null : string;
    }

    public static String replaceAll(String source, String match, String replacement) {
        if (null == source || null == match || null == replacement) {
            throw new IllegalArgumentException("null strings not allowed");
        }
        if (match.length() <= 0) {
            throw new IllegalArgumentException("match must not be empty");
        }
        StringBuilder buffer = new StringBuilder(source.length() + 10);
        int index = 0;
        int newIndex = 0;
        while ((newIndex = source.indexOf(match, index)) >= 0) {
            buffer.append(source.substring(index, newIndex));
            buffer.append(replacement);
            index = newIndex + match.length();
        }
        buffer.append(source.substring(index));
        return buffer.toString();
    }

    public static int compare(String string1, String string2) {
        int endIndex = Math.min(string1.length(), string2.length());
        for (int ii = 0; ii < endIndex; ++ii) {
            if (string1.charAt(ii) == string2.charAt(ii)) continue;
            return ii - 1;
        }
        return endIndex - 1;
    }

    public static String lowerCase(String string, int index) {
        return StringUtil.lowerCase(string, index, -1);
    }

    public static String lowerCase(String string, int startIndex, int endIndex) {
        StringBuilder buffer = new StringBuilder(string);
        if (endIndex <= startIndex) {
            endIndex = startIndex + 1;
        }
        for (int ii = startIndex; ii < endIndex; ++ii) {
            char character = buffer.charAt(ii);
            buffer.setCharAt(ii, Character.toLowerCase(character));
        }
        return buffer.toString();
    }

    public static String fieldToString(String fieldName, Object field) {
        StringBuffer buffer = new StringBuffer();
        if (null == field) {
            buffer.append(fieldName).append(": ").append("null");
        } else if (field.getClass().isArray()) {
            StringUtil.arrayToString(fieldName, field, buffer);
        } else if (field instanceof Collection) {
            StringUtil.collectionToString(fieldName, field, buffer);
        } else if (field instanceof Map) {
            StringUtil.mapToString(fieldName, field, buffer);
        } else {
            buffer.append(fieldName).append(": ").append(field.toString());
        }
        return buffer.toString();
    }

    private static void arrayToString(String fieldName, Object field, StringBuffer buffer) {
        int length = Array.getLength(field);
        if (0 >= length) {
            buffer.append(fieldName).append(": ").append("empty");
        } else {
            for (int ii = 0; ii < length; ++ii) {
                buffer.append(StringUtil.fieldToString(fieldName + " " + ii, Array.get(field, ii)));
                if (ii >= length - 1) continue;
                buffer.append("\n");
            }
        }
    }

    private static void collectionToString(String fieldName, Object field, StringBuffer buffer) {
        ArrayList list = new ArrayList((Collection)field);
        if (0 >= list.size()) {
            buffer.append(fieldName).append(": ").append("empty");
        } else {
            for (int ii = 0; ii < list.size(); ++ii) {
                buffer.append(StringUtil.fieldToString(fieldName + " " + ii, list.get(ii)));
                if (ii >= list.size() - 1) continue;
                buffer.append("\n");
            }
        }
    }

    private static void mapToString(String fieldName, Object field, StringBuffer buffer) {
        Map map = (Map)field;
        if (map.isEmpty()) {
            buffer.append(fieldName).append(": ").append("empty");
        } else {
            Iterator keys = map.keySet().iterator();
            int ii = 0;
            while (keys.hasNext()) {
                Object key = keys.next();
                Object value = map.get(key);
                buffer.append(StringUtil.fieldToString(fieldName + " " + key, value));
                if (ii < map.size() - 1) {
                    buffer.append("\n");
                }
                ++ii;
            }
        }
    }

    public static void appendObjectsAsString(StringBuffer buffer, List<? extends Object> data) {
        for (Object object : data) {
            buffer.append(object);
            buffer.append("\n");
        }
    }

    public static void appendTabs(StringBuffer buffer, int number) {
        for (int ii = 0; ii < number; ++ii) {
            buffer.append("\t");
        }
    }

    public static String[] split(String string, String delim, boolean doTrim) {
        String token;
        int pos = 0;
        int begin = 0;
        ArrayList<String> resultList = new ArrayList<String>();
        while (-1 != (pos = string.indexOf(delim, begin)) && begin < string.length()) {
            token = string.substring(begin, pos);
            if (doTrim) {
                token = token.trim();
            }
            if (token.length() == 0) {
                token = null;
            }
            resultList.add(token);
            begin = pos + delim.length();
        }
        if (begin < string.length()) {
            token = string.substring(begin);
            if (doTrim) {
                token = token.trim();
            }
            if (token.length() == 0) {
                token = null;
            }
            resultList.add(token);
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    public static int countMatches(String string, String other) {
        if (null == string) {
            return 0;
        }
        if (null == other) {
            return 0;
        }
        if (0 >= string.length()) {
            return 0;
        }
        if (0 >= other.length()) {
            return 0;
        }
        int count = 0;
        for (int index = 0; index <= string.length() - other.length() && -1 != (index = string.indexOf(other, index)); index += other.length()) {
            ++count;
        }
        return count;
    }

    public static boolean matchesExact(String source, String target, boolean caseSensitive) {
        if (!caseSensitive) {
            source = source.toLowerCase();
            target = target.toLowerCase();
        }
        return source.equals(target);
    }

    public static boolean matchesContains(String source, String target, boolean caseSensitive) {
        if (!caseSensitive) {
            source = source.toLowerCase();
            target = target.toLowerCase();
        }
        return source.contains(target);
    }

    public static boolean matchesPerl5(String source, String target, boolean caseSensitive) {
        int mask = 1;
        if (caseSensitive) {
            mask = 0;
        }
        try {
            Pattern pattern = new Perl5Compiler().compile(target, mask);
            return new Perl5Matcher().matches(source, pattern);
        }
        catch (MalformedPatternException exc) {
            throw new NestedApplicationException(exc);
        }
    }
}

