/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.util.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CaseAwareMap
implements Map {
    private boolean isCaseSensitive;
    private Map caseInsensitiveMap;
    private Map actualMap;

    public CaseAwareMap() {
        this(false);
    }

    public CaseAwareMap(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
        this.caseInsensitiveMap = new HashMap();
        this.actualMap = new HashMap();
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.clear();
        this.isCaseSensitive = isCaseSensitive;
    }

    @Override
    public void clear() {
        this.caseInsensitiveMap.clear();
        this.actualMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        Object compareKey = this.getCompareKey(key);
        return this.getCompareMap().containsKey(compareKey);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.actualMap.containsValue(value);
    }

    public Set entrySet() {
        return this.actualMap.entrySet();
    }

    public Object get(Object key) {
        Object compareKey = this.getCompareKey(key);
        return this.getCompareMap().get(compareKey);
    }

    @Override
    public boolean isEmpty() {
        return this.size() <= 0;
    }

    public Set keySet() {
        return this.actualMap.keySet();
    }

    public Object put(Object key, Object value) {
        return this.doConsistentModify(key, new ConsistentPut(value));
    }

    public void putAll(Map map) {
        for (Object nextKey : map.keySet()) {
            Object nextValue = map.get(nextKey);
            this.put(nextKey, nextValue);
        }
    }

    public Object remove(Object key) {
        return this.doConsistentModify(key, new ConsistentRemove());
    }

    @Override
    public int size() {
        return this.actualMap.size();
    }

    public Collection values() {
        return this.actualMap.values();
    }

    private boolean areKeysEquals(Object actualKey, Object compareKey) {
        if (null == actualKey && null == compareKey) {
            return true;
        }
        if (null == actualKey) {
            return false;
        }
        if (null == compareKey) {
            return false;
        }
        Object actualCompareKey = this.getCompareKey(actualKey);
        return compareKey.equals(actualCompareKey);
    }

    private boolean isStringKey(Object key) {
        return null != key && key instanceof String;
    }

    private Object getCompareKey(Object key) {
        if (this.isCaseSensitive || !this.isStringKey(key)) {
            return key;
        }
        return ((String)key).toUpperCase();
    }

    private Map getCompareMap() {
        if (this.isCaseSensitive) {
            return this.actualMap;
        }
        return this.caseInsensitiveMap;
    }

    private Object doConsistentModify(Object key, ConsistentModify modifier) {
        Object compareKey = this.getCompareKey(key);
        if (!this.caseInsensitiveMap.containsKey(compareKey)) {
            return modifier.modify(key, compareKey);
        }
        for (Object actualKey : this.actualMap.keySet()) {
            if (!this.areKeysEquals(actualKey, compareKey)) continue;
            return modifier.modify(actualKey, compareKey);
        }
        return null;
    }

    private class ConsistentPut
    implements ConsistentModify {
        private Object value;

        public ConsistentPut(Object value) {
            this.value = value;
        }

        @Override
        public Object modify(Object key1, Object key2) {
            CaseAwareMap.this.actualMap.put(key1, this.value);
            return CaseAwareMap.this.caseInsensitiveMap.put(key2, this.value);
        }
    }

    private class ConsistentRemove
    implements ConsistentModify {
        private ConsistentRemove() {
        }

        @Override
        public Object modify(Object key1, Object key2) {
            CaseAwareMap.this.actualMap.remove(key1);
            return CaseAwareMap.this.caseInsensitiveMap.remove(key2);
        }
    }

    private static interface ConsistentModify {
        public Object modify(Object var1, Object var2);
    }
}

