/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.util;

import com.mockrunner.util.common.FieldUtil;
import java.lang.reflect.Field;
import java.util.Arrays;
import junit.framework.TestCase;

public class FieldUtilTest
extends TestCase {
    public void testGetFieldsSortedByInheritanceHierarchy() throws Exception {
        Field[][] fields = FieldUtil.getFieldsSortedByInheritanceHierarchy(TestSub2.class);
        FieldUtilTest.assertEquals((int)4, (int)fields.length);
        FieldUtilTest.assertEquals((int)2, (int)fields[1].length);
        FieldUtilTest.assertEquals((int)1, (int)fields[2].length);
        FieldUtilTest.assertEquals((int)1, (int)fields[3].length);
        Field testSuperField1 = TestSuper.class.getDeclaredField("testSuperField1");
        Field testSuperField2 = TestSuper.class.getDeclaredField("testSuperField2");
        Field testSubField2 = TestSub.class.getDeclaredField("testSubField2");
        Field testSub2Field2 = TestSub2.class.getDeclaredField("testSub2Field2");
        FieldUtilTest.assertTrue((boolean)Arrays.asList(fields[1]).contains(testSuperField1));
        FieldUtilTest.assertTrue((boolean)Arrays.asList(fields[1]).contains(testSuperField2));
        FieldUtilTest.assertTrue((boolean)Arrays.asList(fields[2]).contains(testSubField2));
        FieldUtilTest.assertTrue((boolean)Arrays.asList(fields[3]).contains(testSub2Field2));
    }

    public static class TestSub2
    extends TestSub {
        public static TestSuper testSub2Field1Static;
        public Class[] testSub2Field2;
    }

    public static class TestSub
    extends TestSuper {
        private static int testSubField1Static;
        protected FieldUtilTest testSubField2;
    }

    public static class TestSuper {
        private int testSuperField1;
        String testSuperField2;
    }
}

