/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.network.DeviceProperties;
import com.microsoft.azure.management.network.AddressSpace;
import com.microsoft.azure.management.network.BgpSettings;
import com.microsoft.azure.management.network.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.rest.SkipParentValidation;
import com.microsoft.azure.Resource;

/**
 * VpnSite Resource.
 */
@JsonFlatten
@SkipParentValidation
public class VpnSiteInner extends Resource {
    /**
     * The VirtualWAN to which the vpnSite belongs.
     */
    @JsonProperty(value = "properties.virtualWAN")
    private SubResource virtualWAN;

    /**
     * The device properties.
     */
    @JsonProperty(value = "properties.deviceProperties")
    private DeviceProperties deviceProperties;

    /**
     * The ip-address for the vpn-site.
     */
    @JsonProperty(value = "properties.ipAddress")
    private String ipAddress;

    /**
     * The key for vpn-site that can be used for connections.
     */
    @JsonProperty(value = "properties.siteKey")
    private String siteKey;

    /**
     * The AddressSpace that contains an array of IP address ranges.
     */
    @JsonProperty(value = "properties.addressSpace")
    private AddressSpace addressSpace;

    /**
     * The set of bgp properties.
     */
    @JsonProperty(value = "properties.bgpProperties")
    private BgpSettings bgpProperties;

    /**
     * The provisioning state of the resource. Possible values include:
     * 'Succeeded', 'Updating', 'Deleting', 'Failed'.
     */
    @JsonProperty(value = "properties.provisioningState")
    private ProvisioningState provisioningState;

    /**
     * Gets a unique read-only string that changes whenever the resource is
     * updated.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /**
     * Resource ID.
     */
    @JsonProperty(value = "id")
    private String id;

    /**
     * Get the virtualWAN value.
     *
     * @return the virtualWAN value
     */
    public SubResource virtualWAN() {
        return this.virtualWAN;
    }

    /**
     * Set the virtualWAN value.
     *
     * @param virtualWAN the virtualWAN value to set
     * @return the VpnSiteInner object itself.
     */
    public VpnSiteInner withVirtualWAN(SubResource virtualWAN) {
        this.virtualWAN = virtualWAN;
        return this;
    }

    /**
     * Get the deviceProperties value.
     *
     * @return the deviceProperties value
     */
    public DeviceProperties deviceProperties() {
        return this.deviceProperties;
    }

    /**
     * Set the deviceProperties value.
     *
     * @param deviceProperties the deviceProperties value to set
     * @return the VpnSiteInner object itself.
     */
    public VpnSiteInner withDeviceProperties(DeviceProperties deviceProperties) {
        this.deviceProperties = deviceProperties;
        return this;
    }

    /**
     * Get the ipAddress value.
     *
     * @return the ipAddress value
     */
    public String ipAddress() {
        return this.ipAddress;
    }

    /**
     * Set the ipAddress value.
     *
     * @param ipAddress the ipAddress value to set
     * @return the VpnSiteInner object itself.
     */
    public VpnSiteInner withIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    /**
     * Get the siteKey value.
     *
     * @return the siteKey value
     */
    public String siteKey() {
        return this.siteKey;
    }

    /**
     * Set the siteKey value.
     *
     * @param siteKey the siteKey value to set
     * @return the VpnSiteInner object itself.
     */
    public VpnSiteInner withSiteKey(String siteKey) {
        this.siteKey = siteKey;
        return this;
    }

    /**
     * Get the addressSpace value.
     *
     * @return the addressSpace value
     */
    public AddressSpace addressSpace() {
        return this.addressSpace;
    }

    /**
     * Set the addressSpace value.
     *
     * @param addressSpace the addressSpace value to set
     * @return the VpnSiteInner object itself.
     */
    public VpnSiteInner withAddressSpace(AddressSpace addressSpace) {
        this.addressSpace = addressSpace;
        return this;
    }

    /**
     * Get the bgpProperties value.
     *
     * @return the bgpProperties value
     */
    public BgpSettings bgpProperties() {
        return this.bgpProperties;
    }

    /**
     * Set the bgpProperties value.
     *
     * @param bgpProperties the bgpProperties value to set
     * @return the VpnSiteInner object itself.
     */
    public VpnSiteInner withBgpProperties(BgpSettings bgpProperties) {
        this.bgpProperties = bgpProperties;
        return this;
    }

    /**
     * Get the provisioningState value.
     *
     * @return the provisioningState value
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Set the provisioningState value.
     *
     * @param provisioningState the provisioningState value to set
     * @return the VpnSiteInner object itself.
     */
    public VpnSiteInner withProvisioningState(ProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    /**
     * Get the etag value.
     *
     * @return the etag value
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the id value.
     *
     * @return the id value
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id value.
     *
     * @param id the id value to set
     * @return the VpnSiteInner object itself.
     */
    public VpnSiteInner withId(String id) {
        this.id = id;
        return this;
    }

}
