/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.network.implementation;

import java.util.List;
import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.network.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.rest.SkipParentValidation;
import com.microsoft.azure.Resource;

/**
 * VirtualWAN Resource.
 */
@JsonFlatten
@SkipParentValidation
public class VirtualWANInner extends Resource {
    /**
     * Vpn encryption to be disabled or not.
     */
    @JsonProperty(value = "properties.disableVpnEncryption")
    private Boolean disableVpnEncryption;

    /**
     * List of VirtualHubs in the VirtualWAN.
     */
    @JsonProperty(value = "properties.virtualHubs", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> virtualHubs;

    /**
     * The vpnSites property.
     */
    @JsonProperty(value = "properties.vpnSites", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> vpnSites;

    /**
     * The provisioning state of the resource. Possible values include:
     * 'Succeeded', 'Updating', 'Deleting', 'Failed'.
     */
    @JsonProperty(value = "properties.provisioningState")
    private ProvisioningState provisioningState;

    /**
     * Gets a unique read-only string that changes whenever the resource is
     * updated.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /**
     * Resource ID.
     */
    @JsonProperty(value = "id")
    private String id;

    /**
     * Get the disableVpnEncryption value.
     *
     * @return the disableVpnEncryption value
     */
    public Boolean disableVpnEncryption() {
        return this.disableVpnEncryption;
    }

    /**
     * Set the disableVpnEncryption value.
     *
     * @param disableVpnEncryption the disableVpnEncryption value to set
     * @return the VirtualWANInner object itself.
     */
    public VirtualWANInner withDisableVpnEncryption(Boolean disableVpnEncryption) {
        this.disableVpnEncryption = disableVpnEncryption;
        return this;
    }

    /**
     * Get the virtualHubs value.
     *
     * @return the virtualHubs value
     */
    public List<SubResource> virtualHubs() {
        return this.virtualHubs;
    }

    /**
     * Get the vpnSites value.
     *
     * @return the vpnSites value
     */
    public List<SubResource> vpnSites() {
        return this.vpnSites;
    }

    /**
     * Get the provisioningState value.
     *
     * @return the provisioningState value
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Set the provisioningState value.
     *
     * @param provisioningState the provisioningState value to set
     * @return the VirtualWANInner object itself.
     */
    public VirtualWANInner withProvisioningState(ProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    /**
     * Get the etag value.
     *
     * @return the etag value
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the id value.
     *
     * @return the id value
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id value.
     *
     * @param id the id value to set
     * @return the VirtualWANInner object itself.
     */
    public VirtualWANInner withId(String id) {
        this.id = id;
        return this;
    }

}
