/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerservice.implementation;

import java.util.List;
import com.microsoft.azure.management.containerservice.ManagedClusterAgentPoolProfile;
import com.microsoft.azure.management.containerservice.ContainerServiceLinuxProfile;
import com.microsoft.azure.management.containerservice.ManagedClusterServicePrincipalProfile;
import java.util.Map;
import com.microsoft.azure.management.containerservice.ManagedClusterAddonProfile;
import com.microsoft.azure.management.containerservice.ContainerServiceNetworkProfile;
import com.microsoft.azure.management.containerservice.ManagedClusterAADProfile;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.Resource;

/**
 * Managed cluster.
 */
@JsonFlatten
public class ManagedClusterInner extends Resource {
    /**
     * The current deployment or provisioning state, which only appears in the
     * response.
     */
    @JsonProperty(value = "properties.provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;

    /**
     * Version of Kubernetes specified when creating the managed cluster.
     */
    @JsonProperty(value = "properties.kubernetesVersion")
    private String kubernetesVersion;

    /**
     * DNS prefix specified when creating the managed cluster.
     */
    @JsonProperty(value = "properties.dnsPrefix")
    private String dnsPrefix;

    /**
     * FDQN for the master pool.
     */
    @JsonProperty(value = "properties.fqdn", access = JsonProperty.Access.WRITE_ONLY)
    private String fqdn;

    /**
     * Properties of the agent pool.
     */
    @JsonProperty(value = "properties.agentPoolProfiles")
    private List<ManagedClusterAgentPoolProfile> agentPoolProfiles;

    /**
     * Profile for Linux VMs in the container service cluster.
     */
    @JsonProperty(value = "properties.linuxProfile")
    private ContainerServiceLinuxProfile linuxProfile;

    /**
     * Information about a service principal identity for the cluster to use
     * for manipulating Azure APIs.
     */
    @JsonProperty(value = "properties.servicePrincipalProfile")
    private ManagedClusterServicePrincipalProfile servicePrincipalProfile;

    /**
     * Profile of managed cluster add-on.
     */
    @JsonProperty(value = "properties.addonProfiles")
    private Map<String, ManagedClusterAddonProfile> addonProfiles;

    /**
     * Name of the resource group containing agent pool nodes.
     */
    @JsonProperty(value = "properties.nodeResourceGroup", access = JsonProperty.Access.WRITE_ONLY)
    private String nodeResourceGroup;

    /**
     * Whether to enable Kubernetes Role-Based Access Control.
     */
    @JsonProperty(value = "properties.enableRBAC")
    private Boolean enableRBAC;

    /**
     * Profile of network configuration.
     */
    @JsonProperty(value = "properties.networkProfile")
    private ContainerServiceNetworkProfile networkProfile;

    /**
     * Profile of Azure Active Directory configuration.
     */
    @JsonProperty(value = "properties.aadProfile")
    private ManagedClusterAADProfile aadProfile;

    /**
     * Get the provisioningState value.
     *
     * @return the provisioningState value
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the kubernetesVersion value.
     *
     * @return the kubernetesVersion value
     */
    public String kubernetesVersion() {
        return this.kubernetesVersion;
    }

    /**
     * Set the kubernetesVersion value.
     *
     * @param kubernetesVersion the kubernetesVersion value to set
     * @return the ManagedClusterInner object itself.
     */
    public ManagedClusterInner withKubernetesVersion(String kubernetesVersion) {
        this.kubernetesVersion = kubernetesVersion;
        return this;
    }

    /**
     * Get the dnsPrefix value.
     *
     * @return the dnsPrefix value
     */
    public String dnsPrefix() {
        return this.dnsPrefix;
    }

    /**
     * Set the dnsPrefix value.
     *
     * @param dnsPrefix the dnsPrefix value to set
     * @return the ManagedClusterInner object itself.
     */
    public ManagedClusterInner withDnsPrefix(String dnsPrefix) {
        this.dnsPrefix = dnsPrefix;
        return this;
    }

    /**
     * Get the fqdn value.
     *
     * @return the fqdn value
     */
    public String fqdn() {
        return this.fqdn;
    }

    /**
     * Get the agentPoolProfiles value.
     *
     * @return the agentPoolProfiles value
     */
    public List<ManagedClusterAgentPoolProfile> agentPoolProfiles() {
        return this.agentPoolProfiles;
    }

    /**
     * Set the agentPoolProfiles value.
     *
     * @param agentPoolProfiles the agentPoolProfiles value to set
     * @return the ManagedClusterInner object itself.
     */
    public ManagedClusterInner withAgentPoolProfiles(List<ManagedClusterAgentPoolProfile> agentPoolProfiles) {
        this.agentPoolProfiles = agentPoolProfiles;
        return this;
    }

    /**
     * Get the linuxProfile value.
     *
     * @return the linuxProfile value
     */
    public ContainerServiceLinuxProfile linuxProfile() {
        return this.linuxProfile;
    }

    /**
     * Set the linuxProfile value.
     *
     * @param linuxProfile the linuxProfile value to set
     * @return the ManagedClusterInner object itself.
     */
    public ManagedClusterInner withLinuxProfile(ContainerServiceLinuxProfile linuxProfile) {
        this.linuxProfile = linuxProfile;
        return this;
    }

    /**
     * Get the servicePrincipalProfile value.
     *
     * @return the servicePrincipalProfile value
     */
    public ManagedClusterServicePrincipalProfile servicePrincipalProfile() {
        return this.servicePrincipalProfile;
    }

    /**
     * Set the servicePrincipalProfile value.
     *
     * @param servicePrincipalProfile the servicePrincipalProfile value to set
     * @return the ManagedClusterInner object itself.
     */
    public ManagedClusterInner withServicePrincipalProfile(ManagedClusterServicePrincipalProfile servicePrincipalProfile) {
        this.servicePrincipalProfile = servicePrincipalProfile;
        return this;
    }

    /**
     * Get the addonProfiles value.
     *
     * @return the addonProfiles value
     */
    public Map<String, ManagedClusterAddonProfile> addonProfiles() {
        return this.addonProfiles;
    }

    /**
     * Set the addonProfiles value.
     *
     * @param addonProfiles the addonProfiles value to set
     * @return the ManagedClusterInner object itself.
     */
    public ManagedClusterInner withAddonProfiles(Map<String, ManagedClusterAddonProfile> addonProfiles) {
        this.addonProfiles = addonProfiles;
        return this;
    }

    /**
     * Get the nodeResourceGroup value.
     *
     * @return the nodeResourceGroup value
     */
    public String nodeResourceGroup() {
        return this.nodeResourceGroup;
    }

    /**
     * Get the enableRBAC value.
     *
     * @return the enableRBAC value
     */
    public Boolean enableRBAC() {
        return this.enableRBAC;
    }

    /**
     * Set the enableRBAC value.
     *
     * @param enableRBAC the enableRBAC value to set
     * @return the ManagedClusterInner object itself.
     */
    public ManagedClusterInner withEnableRBAC(Boolean enableRBAC) {
        this.enableRBAC = enableRBAC;
        return this;
    }

    /**
     * Get the networkProfile value.
     *
     * @return the networkProfile value
     */
    public ContainerServiceNetworkProfile networkProfile() {
        return this.networkProfile;
    }

    /**
     * Set the networkProfile value.
     *
     * @param networkProfile the networkProfile value to set
     * @return the ManagedClusterInner object itself.
     */
    public ManagedClusterInner withNetworkProfile(ContainerServiceNetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    /**
     * Get the aadProfile value.
     *
     * @return the aadProfile value
     */
    public ManagedClusterAADProfile aadProfile() {
        return this.aadProfile;
    }

    /**
     * Set the aadProfile value.
     *
     * @param aadProfile the aadProfile value to set
     * @return the ManagedClusterInner object itself.
     */
    public ManagedClusterInner withAadProfile(ManagedClusterAADProfile aadProfile) {
        this.aadProfile = aadProfile;
        return this;
    }

}
