/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault;

import com.microsoft.azure.keyvault.KeyVaultInternalClientImpl;
import com.microsoft.azure.keyvault.SecretOperations;
import com.microsoft.azure.keyvault.SecretRequestMessageWithRawJsonContent;
import com.microsoft.azure.keyvault.SecretResponseMessageWithRawJsonContent;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.core.utils.StreamUtils;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

class SecretOperationsImpl
implements ServiceOperations<KeyVaultInternalClientImpl>,
SecretOperations {
    private KeyVaultInternalClientImpl client;

    SecretOperationsImpl(KeyVaultInternalClientImpl client) {
        this.client = client;
    }

    public KeyVaultInternalClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<SecretResponseMessageWithRawJsonContent> deleteAsync(final String secretIdentifier) {
        return this.getClient().getExecutorService().submit(new Callable<SecretResponseMessageWithRawJsonContent>(){

            @Override
            public SecretResponseMessageWithRawJsonContent call() throws Exception {
                return SecretOperationsImpl.this.delete(secretIdentifier);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecretResponseMessageWithRawJsonContent delete(String secretIdentifier) throws IOException, ServiceException {
        if (secretIdentifier == null) {
            throw new NullPointerException("secretIdentifier");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("secretIdentifier", secretIdentifier);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        String url = "";
        url = url + secretIdentifier;
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + this.getClient().getApiVersion());
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.create((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity(), (String)"Json");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            SecretResponseMessageWithRawJsonContent result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new SecretResponseMessageWithRawJsonContent();
            result.setResponse(StreamUtils.toString((InputStream)responseContent));
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            SecretResponseMessageWithRawJsonContent secretResponseMessageWithRawJsonContent = result;
            return secretResponseMessageWithRawJsonContent;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<SecretResponseMessageWithRawJsonContent> getAsync(final String secretIdentifier) {
        return this.getClient().getExecutorService().submit(new Callable<SecretResponseMessageWithRawJsonContent>(){

            @Override
            public SecretResponseMessageWithRawJsonContent call() throws Exception {
                return SecretOperationsImpl.this.get(secretIdentifier);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecretResponseMessageWithRawJsonContent get(String secretIdentifier) throws IOException, ServiceException {
        if (secretIdentifier == null) {
            throw new NullPointerException("secretIdentifier");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("secretIdentifier", secretIdentifier);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + secretIdentifier;
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + this.getClient().getApiVersion());
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.create((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity(), (String)"Json");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            SecretResponseMessageWithRawJsonContent result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new SecretResponseMessageWithRawJsonContent();
            result.setResponse(StreamUtils.toString((InputStream)responseContent));
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            SecretResponseMessageWithRawJsonContent secretResponseMessageWithRawJsonContent = result;
            return secretResponseMessageWithRawJsonContent;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<SecretResponseMessageWithRawJsonContent> listAsync(final String vault, final Integer top) {
        return this.getClient().getExecutorService().submit(new Callable<SecretResponseMessageWithRawJsonContent>(){

            @Override
            public SecretResponseMessageWithRawJsonContent call() throws Exception {
                return SecretOperationsImpl.this.list(vault, top);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecretResponseMessageWithRawJsonContent list(String vault, Integer top) throws IOException, ServiceException {
        if (vault == null) {
            throw new NullPointerException("vault");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("vault", vault);
            tracingParameters.put("top", top);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + vault;
        url = url + "/secrets/";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + this.getClient().getApiVersion());
        if (top != null) {
            queryParameters.add("maxresults=" + URLEncoder.encode(Integer.toString(top), "UTF-8"));
        }
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.create((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity(), (String)"Json");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            SecretResponseMessageWithRawJsonContent result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new SecretResponseMessageWithRawJsonContent();
            result.setResponse(StreamUtils.toString((InputStream)responseContent));
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            SecretResponseMessageWithRawJsonContent secretResponseMessageWithRawJsonContent = result;
            return secretResponseMessageWithRawJsonContent;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<SecretResponseMessageWithRawJsonContent> listNextAsync(final String nextLink) {
        return this.getClient().getExecutorService().submit(new Callable<SecretResponseMessageWithRawJsonContent>(){

            @Override
            public SecretResponseMessageWithRawJsonContent call() throws Exception {
                return SecretOperationsImpl.this.listNext(nextLink);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecretResponseMessageWithRawJsonContent listNext(String nextLink) throws IOException, ServiceException {
        if (nextLink == null) {
            throw new NullPointerException("nextLink");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("nextLink", nextLink);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listNextAsync", tracingParameters);
        }
        String url = "";
        url = url + nextLink;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.create((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity(), (String)"Json");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            SecretResponseMessageWithRawJsonContent result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new SecretResponseMessageWithRawJsonContent();
            result.setResponse(StreamUtils.toString((InputStream)responseContent));
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            SecretResponseMessageWithRawJsonContent secretResponseMessageWithRawJsonContent = result;
            return secretResponseMessageWithRawJsonContent;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<SecretResponseMessageWithRawJsonContent> listVersionsAsync(final String vault, final String secretName, final Integer top) {
        return this.getClient().getExecutorService().submit(new Callable<SecretResponseMessageWithRawJsonContent>(){

            @Override
            public SecretResponseMessageWithRawJsonContent call() throws Exception {
                return SecretOperationsImpl.this.listVersions(vault, secretName, top);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecretResponseMessageWithRawJsonContent listVersions(String vault, String secretName, Integer top) throws IOException, ServiceException {
        if (vault == null) {
            throw new NullPointerException("vault");
        }
        if (secretName == null) {
            throw new NullPointerException("secretName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("vault", vault);
            tracingParameters.put("secretName", secretName);
            tracingParameters.put("top", top);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listVersionsAsync", tracingParameters);
        }
        String url = "";
        url = url + vault;
        url = url + "/secrets/";
        url = url + URLEncoder.encode(secretName, "UTF-8");
        url = url + "/versions";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + this.getClient().getApiVersion());
        if (top != null) {
            queryParameters.add("maxresults=" + URLEncoder.encode(Integer.toString(top), "UTF-8"));
        }
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.create((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity(), (String)"Json");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            SecretResponseMessageWithRawJsonContent result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new SecretResponseMessageWithRawJsonContent();
            result.setResponse(StreamUtils.toString((InputStream)responseContent));
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            SecretResponseMessageWithRawJsonContent secretResponseMessageWithRawJsonContent = result;
            return secretResponseMessageWithRawJsonContent;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<SecretResponseMessageWithRawJsonContent> listVersionsNextAsync(final String nextLink) {
        return this.getClient().getExecutorService().submit(new Callable<SecretResponseMessageWithRawJsonContent>(){

            @Override
            public SecretResponseMessageWithRawJsonContent call() throws Exception {
                return SecretOperationsImpl.this.listVersionsNext(nextLink);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecretResponseMessageWithRawJsonContent listVersionsNext(String nextLink) throws IOException, ServiceException {
        if (nextLink == null) {
            throw new NullPointerException("nextLink");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("nextLink", nextLink);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listVersionsNextAsync", tracingParameters);
        }
        String url = "";
        url = url + nextLink;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.create((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity(), (String)"Json");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            SecretResponseMessageWithRawJsonContent result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new SecretResponseMessageWithRawJsonContent();
            result.setResponse(StreamUtils.toString((InputStream)responseContent));
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            SecretResponseMessageWithRawJsonContent secretResponseMessageWithRawJsonContent = result;
            return secretResponseMessageWithRawJsonContent;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<SecretResponseMessageWithRawJsonContent> setAsync(final String secretIdentifier, final SecretRequestMessageWithRawJsonContent request) {
        return this.getClient().getExecutorService().submit(new Callable<SecretResponseMessageWithRawJsonContent>(){

            @Override
            public SecretResponseMessageWithRawJsonContent call() throws Exception {
                return SecretOperationsImpl.this.set(secretIdentifier, request);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecretResponseMessageWithRawJsonContent set(String secretIdentifier, SecretRequestMessageWithRawJsonContent request) throws IOException, ServiceException {
        if (secretIdentifier == null) {
            throw new NullPointerException("secretIdentifier");
        }
        if (request == null) {
            throw new NullPointerException("request");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("secretIdentifier", secretIdentifier);
            tracingParameters.put("request", request);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"setAsync", tracingParameters);
        }
        String url = "";
        url = url + secretIdentifier;
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + this.getClient().getApiVersion());
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = request.getRawJsonRequest();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.create((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity(), (String)"Json");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            SecretResponseMessageWithRawJsonContent result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new SecretResponseMessageWithRawJsonContent();
            result.setResponse(StreamUtils.toString((InputStream)responseContent));
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            SecretResponseMessageWithRawJsonContent secretResponseMessageWithRawJsonContent = result;
            return secretResponseMessageWithRawJsonContent;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<SecretResponseMessageWithRawJsonContent> updateAsync(final String secretIdentifier, final SecretRequestMessageWithRawJsonContent request) {
        return this.getClient().getExecutorService().submit(new Callable<SecretResponseMessageWithRawJsonContent>(){

            @Override
            public SecretResponseMessageWithRawJsonContent call() throws Exception {
                return SecretOperationsImpl.this.update(secretIdentifier, request);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecretResponseMessageWithRawJsonContent update(String secretIdentifier, SecretRequestMessageWithRawJsonContent request) throws IOException, ServiceException {
        if (secretIdentifier == null) {
            throw new NullPointerException("secretIdentifier");
        }
        if (request == null) {
            throw new NullPointerException("request");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("secretIdentifier", secretIdentifier);
            tracingParameters.put("request", request);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"updateAsync", tracingParameters);
        }
        String url = "";
        url = url + secretIdentifier;
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + this.getClient().getApiVersion());
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        url = url.replace(" ", "%20");
        HttpPatch httpRequest = new HttpPatch(url);
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("client-request-id", UUID.randomUUID().toString());
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = request.getRawJsonRequest();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) >= 400) {
                ServiceException ex = ServiceException.create((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity(), (String)"Json");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            SecretResponseMessageWithRawJsonContent result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new SecretResponseMessageWithRawJsonContent();
            result.setResponse(StreamUtils.toString((InputStream)responseContent));
            result.setStatusCode(statusCode);
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            SecretResponseMessageWithRawJsonContent secretResponseMessageWithRawJsonContent = result;
            return secretResponseMessageWithRawJsonContent;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

