/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

abstract class FutureAdapter<A, B>
implements Future<B> {
    private final Future<A> inner;

    protected FutureAdapter(Future<A> inner) {
        this.inner = inner;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.inner.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.inner.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.inner.isDone();
    }

    @Override
    public B get() throws InterruptedException, ExecutionException {
        try {
            return this.translate(this.inner.get());
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public B get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return this.translate(this.inner.get(timeout, unit));
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
    }

    protected abstract B translate(A var1) throws IOException;
}

