/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models.property.bean;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.ResolvedMember;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mangofactory.swagger.models.Annotations;
import com.mangofactory.swagger.models.BeanPropertyNamingStrategy;
import com.mangofactory.swagger.models.alternates.AlternateTypeProvider;
import com.mangofactory.swagger.models.property.BeanPropertyDefinitions;
import com.mangofactory.swagger.models.property.ModelProperty;
import com.mangofactory.swagger.models.property.bean.Accessors;
import com.mangofactory.swagger.models.property.bean.AccessorsProvider;
import com.mangofactory.swagger.models.property.bean.BeanModelProperty;
import com.mangofactory.swagger.models.property.provider.ModelPropertiesProvider;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BeanModelPropertyProvider
implements ModelPropertiesProvider {
    private static final Logger LOG = LoggerFactory.getLogger(BeanModelPropertyProvider.class);
    private final AccessorsProvider accessors;
    private final BeanPropertyNamingStrategy namingStrategy;
    private final TypeResolver typeResolver;
    private final AlternateTypeProvider alternateTypeProvider;
    private ObjectMapper objectMapper;

    @Autowired
    public BeanModelPropertyProvider(AccessorsProvider accessors, TypeResolver typeResolver, AlternateTypeProvider alternateTypeProvider, BeanPropertyNamingStrategy namingStrategy) {
        this.typeResolver = typeResolver;
        this.alternateTypeProvider = alternateTypeProvider;
        this.accessors = accessors;
        this.namingStrategy = namingStrategy;
    }

    @Override
    public Iterable<? extends ModelProperty> propertiesForSerialization(ResolvedType resolvedType) {
        ArrayList serializationCandidates = Lists.newArrayList();
        SerializationConfig serializationConfig = this.objectMapper.getSerializationConfig();
        BeanDescription beanDescription = serializationConfig.introspect(TypeFactory.defaultInstance().constructType((Type)resolvedType.getErasedType()));
        ImmutableMap propertyLookup = Maps.uniqueIndex((Iterable)beanDescription.findProperties(), BeanPropertyDefinitions.beanPropertyByInternalName());
        for (Map.Entry propertyDefinitionEntry : propertyLookup.entrySet()) {
            BeanPropertyDefinition propertyDefinition = (BeanPropertyDefinition)propertyDefinitionEntry.getValue();
            Optional<BeanPropertyDefinition> jacksonProperty = BeanPropertyDefinitions.jacksonPropertyWithSameInternalName(beanDescription, propertyDefinition);
            AnnotatedMember member = propertyDefinition.getPrimaryMember();
            Optional<ResolvedMethod> accessorMethodOptional = this.findAccessorMethod(resolvedType, (String)propertyDefinitionEntry.getKey(), member);
            if (!accessorMethodOptional.isPresent()) continue;
            ResolvedMethod accessorMethod = (ResolvedMethod)accessorMethodOptional.get();
            serializationCandidates.addAll(Lists.newArrayList(this.addSerializationCandidates(member, accessorMethod, jacksonProperty)));
        }
        return serializationCandidates;
    }

    @Override
    public Iterable<? extends ModelProperty> propertiesForDeserialization(ResolvedType resolvedType) {
        ArrayList serializationCandidates = Lists.newArrayList();
        DeserializationConfig serializationConfig = this.objectMapper.getDeserializationConfig();
        BeanDescription beanDescription = serializationConfig.introspect(TypeFactory.defaultInstance().constructType((Type)resolvedType.getErasedType()));
        ImmutableMap propertyLookup = Maps.uniqueIndex((Iterable)beanDescription.findProperties(), BeanPropertyDefinitions.beanPropertyByInternalName());
        for (Map.Entry propertyDefinitionEntry : propertyLookup.entrySet()) {
            BeanPropertyDefinition propertyDefinition = (BeanPropertyDefinition)propertyDefinitionEntry.getValue();
            Optional<BeanPropertyDefinition> jacksonProperty = BeanPropertyDefinitions.jacksonPropertyWithSameInternalName(beanDescription, propertyDefinition);
            try {
                AnnotatedMember member = propertyDefinition.getPrimaryMember();
                Optional<ResolvedMethod> accessorMethodOptional = this.findAccessorMethod(resolvedType, (String)propertyDefinitionEntry.getKey(), member);
                if (!accessorMethodOptional.isPresent()) continue;
                ResolvedMethod accessorMethod = (ResolvedMethod)accessorMethodOptional.get();
                serializationCandidates.addAll(Lists.newArrayList(this.addDeserializationCandidates(member, accessorMethod, jacksonProperty)));
            }
            catch (Exception e) {
                LOG.warn(e.getMessage());
            }
        }
        return serializationCandidates;
    }

    @Override
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.namingStrategy.setObjectMapper(objectMapper);
    }

    private Optional<ResolvedMethod> findAccessorMethod(ResolvedType resolvedType, final String propertyName, final AnnotatedMember member) {
        return Iterables.tryFind(this.accessors.in(resolvedType), (Predicate)new Predicate<ResolvedMethod>(){

            public boolean apply(ResolvedMethod accessorMethod) {
                return BeanModelProperty.accessorMemberIs((ResolvedMember)accessorMethod, BeanModelPropertyProvider.this.methodName(member)) && propertyName.equals(Accessors.propertyName((Method)accessorMethod.getRawMember()));
            }
        });
    }

    @VisibleForTesting
    Iterable<? extends ModelProperty> addSerializationCandidates(AnnotatedMember member, ResolvedMethod childProperty, Optional<BeanPropertyDefinition> jacksonProperty) {
        if (member instanceof AnnotatedMethod && Annotations.memberIsUnwrapped(member)) {
            Iterable<? extends ModelProperty> properties = Accessors.isGetter(((AnnotatedMethod)member).getMember()) ? this.propertiesForSerialization(childProperty.getReturnType()) : this.propertiesForSerialization(childProperty.getArgumentType(0));
            return properties;
        }
        return Lists.newArrayList((Object[])new BeanModelProperty[]{this.beanModelProperty(childProperty, jacksonProperty, true)});
    }

    @VisibleForTesting
    Iterable<? extends ModelProperty> addDeserializationCandidates(AnnotatedMember member, ResolvedMethod childProperty, Optional<BeanPropertyDefinition> jacksonProperty) {
        if (member instanceof AnnotatedMethod && Annotations.memberIsUnwrapped(member)) {
            Iterable<? extends ModelProperty> properties = Accessors.isGetter(((AnnotatedMethod)member).getMember()) ? this.propertiesForDeserialization(childProperty.getReturnType()) : this.propertiesForDeserialization(childProperty.getArgumentType(0));
            return properties;
        }
        return Lists.newArrayList((Object[])new BeanModelProperty[]{this.beanModelProperty(childProperty, jacksonProperty, true)});
    }

    private String methodName(AnnotatedMember member) {
        if (member == null || member.getMember() == null) {
            return "";
        }
        return member.getMember().getName();
    }

    private BeanModelProperty beanModelProperty(ResolvedMethod childProperty, Optional<BeanPropertyDefinition> jacksonProperty, boolean forSerialization) {
        BeanPropertyDefinition beanPropertyDefinition = (BeanPropertyDefinition)jacksonProperty.get();
        String propertyName = BeanPropertyDefinitions.name(beanPropertyDefinition, forSerialization, this.namingStrategy);
        return new BeanModelProperty(propertyName, beanPropertyDefinition, childProperty, Accessors.isGetter((Method)childProperty.getRawMember()), this.typeResolver, this.alternateTypeProvider);
    }
}

