/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.mangofactory.swagger.models.dto.AllowableValues;
import com.mangofactory.swagger.models.dto.DataType;
import com.mangofactory.swagger.models.dto.SwaggerDataType;
import org.springframework.util.StringUtils;

public class Parameter {
    @JsonProperty
    @JsonUnwrapped
    private final SwaggerDataType parameterType;
    private final String name;
    private final String description;
    private final String defaultValue;
    private final Boolean required;
    private final Boolean allowMultiple;
    @JsonProperty
    @JsonUnwrapped
    private final AllowableValues allowableValues;
    private final String paramType;
    private final String paramAccess;

    public Parameter(String name, String description, String defaultValue, Boolean required, Boolean allowMultiple, String dataType, AllowableValues allowableValues, String paramType, String paramAccess) {
        this.description = description;
        this.defaultValue = defaultValue;
        this.required = required;
        this.allowMultiple = allowMultiple;
        this.allowableValues = allowableValues;
        this.paramType = paramType;
        this.paramAccess = paramAccess;
        this.name = this.maybeOverrideName(name);
        this.parameterType = new DataType(dataType);
    }

    private String maybeOverrideName(String aName) {
        if (StringUtils.hasText((String)this.paramType) && this.paramType.equals("body")) {
            return this.paramType;
        }
        return aName;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Boolean isRequired() {
        return this.required;
    }

    public Boolean isAllowMultiple() {
        return this.allowMultiple;
    }

    public AllowableValues getAllowableValues() {
        return this.allowableValues;
    }

    public String getParamType() {
        return this.paramType;
    }

    public String getParamAccess() {
        return this.paramAccess;
    }

    public SwaggerDataType getParameterType() {
        return this.parameterType;
    }
}

