/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.collect.Sets;
import com.mangofactory.swagger.models.ResolvedTypes;
import java.lang.reflect.Type;
import java.util.Set;

public class ModelContext {
    private final ModelContext parentContext;
    private final Type type;
    private final boolean returnType;
    private Set<ResolvedType> seenTypes = Sets.newHashSet();

    ModelContext(Type type, boolean returnType) {
        this.parentContext = null;
        this.type = type;
        this.returnType = returnType;
    }

    ModelContext(ModelContext parentContext, ResolvedType input) {
        this.parentContext = parentContext;
        this.type = input;
        this.returnType = parentContext.isReturnType();
    }

    public Type getType() {
        return this.type;
    }

    public ResolvedType resolvedType(TypeResolver resolver) {
        return ResolvedTypes.asResolved(resolver, this.getType());
    }

    public boolean isReturnType() {
        return this.returnType;
    }

    public static ModelContext inputParam(Type type) {
        return new ModelContext(type, false);
    }

    public static ModelContext returnValue(Type type) {
        return new ModelContext(type, true);
    }

    public static ModelContext fromParent(ModelContext context, ResolvedType input) {
        return new ModelContext(context, input);
    }

    public boolean hasSeenBefore(ResolvedType resolvedType) {
        return this.seenTypes.contains(resolvedType) || this.seenTypes.contains(ResolvedTypes.asResolved(new TypeResolver(), resolvedType.getErasedType())) || this.parentHasSeenBefore(resolvedType);
    }

    private boolean parentHasSeenBefore(ResolvedType resolvedType) {
        if (this.parentContext == null) {
            return false;
        }
        return this.parentContext.hasSeenBefore(resolvedType);
    }

    public void seen(ResolvedType resolvedType) {
        this.seenTypes.add(resolvedType);
    }
}

