/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.encoding.DeserializerTarget;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MapDeserializer
extends DeserializerImpl {
    protected static Log log = LogFactory.getLog(MapDeserializer.class.getName());
    public static final Object KEYHINT = new Object();
    public static final Object VALHINT = new Object();
    public static final Object NILHINT = new Object();

    @Override
    public void onStartElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter MapDeserializer::startElement()");
        }
        if (context.isNil(attributes)) {
            return;
        }
        this.setValue(new HashMap());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: MapDeserializer::startElement()");
        }
    }

    @Override
    public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: MapDeserializer::onStartChild()");
        }
        if (localName.equals("item")) {
            SOAPConstants soapConstants = context.getSOAPConstants();
            String href = attributes.getValue(soapConstants.getAttrHref());
            if (href != null) {
                Object ref = context.getObjectByRef(href);
                BigItemHandler handler = new BigItemHandler(this);
                this.addChildDeserializer(handler);
                return handler;
            }
            ItemHandler handler = new ItemHandler(this);
            this.addChildDeserializer(handler);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: MapDeserializer::onStartChild()");
            }
            return handler;
        }
        return this;
    }

    @Override
    public void setChildValue(Object value, Object hint) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("gotValue00", "MapDeserializer", "" + value));
        }
        ((Map)this.value).put(hint, value);
    }

    class BigItemHandler
    extends DeserializerImpl {
        Object key;
        Object myValue;
        int numSet = 0;
        MapDeserializer md = null;

        BigItemHandler(MapDeserializer md) {
            this.md = md;
        }

        @Override
        public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
            SOAPConstants soapConstants;
            String href;
            QName typeQName = context.getTypeFromAttributes(namespace, localName, attributes);
            Deserializer dser = context.getDeserializerForType(typeQName);
            if (dser == null) {
                dser = new DeserializerImpl();
            }
            if ((href = attributes.getValue((soapConstants = context.getSOAPConstants()).getAttrHref())) != null) {
                Object ref = context.getObjectByRef(href);
                ItemHandler handler = new ItemHandler(this.md);
                this.addChildDeserializer(handler);
                return handler;
            }
            this.addChildDeserializer(dser);
            return (SOAPHandler)((Object)dser);
        }
    }

    class ItemHandler
    extends DeserializerImpl {
        Object key;
        Object myValue;
        int numSet = 0;
        MapDeserializer md = null;

        ItemHandler(MapDeserializer md) {
            this.md = md;
        }

        @Override
        public void setChildValue(Object val, Object hint) throws SAXException {
            if (hint == KEYHINT) {
                this.key = val;
            } else if (hint == VALHINT) {
                this.myValue = val;
            } else if (hint != NILHINT) {
                return;
            }
            ++this.numSet;
            if (this.numSet == 2) {
                this.md.setChildValue(this.myValue, this.key);
            }
        }

        @Override
        public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
            QName typeQName = context.getTypeFromAttributes(namespace, localName, attributes);
            Deserializer dser = context.getDeserializerForType(typeQName);
            if (dser == null) {
                dser = new DeserializerImpl();
            }
            DeserializerTarget dt = null;
            if (context.isNil(attributes)) {
                dt = new DeserializerTarget(this, NILHINT);
            } else if (localName.equals("key")) {
                dt = new DeserializerTarget(this, KEYHINT);
            } else if (localName.equals("value")) {
                dt = new DeserializerTarget(this, VALHINT);
            }
            if (dt != null) {
                dser.registerValueTarget(dt);
            }
            this.addChildDeserializer(dser);
            return (SOAPHandler)((Object)dser);
        }
    }
}

