/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.payroll.v1.resource;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.payroll.v1.model.QueryDatasourceRecordReq;
import com.lark.oapi.service.payroll.v1.model.QueryDatasourceRecordResp;
import com.lark.oapi.service.payroll.v1.model.SaveDatasourceRecordReq;
import com.lark.oapi.service.payroll.v1.model.SaveDatasourceRecordResp;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasourceRecord {
    private static final Logger log = LoggerFactory.getLogger(DatasourceRecord.class);
    private final Config config;

    public DatasourceRecord(Config config) {
        this.config = config;
    }

    public QueryDatasourceRecordResp query(QueryDatasourceRecordReq req, RequestOptions reqOptions) throws Exception {
        RawResponse httpResponse;
        QueryDatasourceRecordResp resp;
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/payroll/v1/datasource_records/query", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req), QueryDatasourceRecordResp.class)) == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/payroll/v1/datasource_records/query", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public QueryDatasourceRecordResp query(QueryDatasourceRecordReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/payroll/v1/datasource_records/query", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
        QueryDatasourceRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, QueryDatasourceRecordResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/payroll/v1/datasource_records/query", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public SaveDatasourceRecordResp save(SaveDatasourceRecordReq req, RequestOptions reqOptions) throws Exception {
        RawResponse httpResponse;
        SaveDatasourceRecordResp resp;
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/payroll/v1/datasource_records/save", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req), SaveDatasourceRecordResp.class)) == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/payroll/v1/datasource_records/save", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public SaveDatasourceRecordResp save(SaveDatasourceRecordReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/payroll/v1/datasource_records/save", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
        SaveDatasourceRecordResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, SaveDatasourceRecordResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/payroll/v1/datasource_records/save", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }
}

